/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import sun.nio.fs.AixFileSystem;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class AixFileStore
extends UnixFileStore {
    AixFileStore(UnixPath file) throws IOException {
        super(file);
    }

    AixFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        super(fs, entry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        AixFileSystem fs = (AixFileSystem)this.file().getFileSystem();
        UnixPath path = null;
        try {
            byte[] rp = UnixNativeDispatcher.realpath(this.file());
            path = new UnixPath((UnixFileSystem)fs, rp);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file());
        }
        for (UnixPath parent = path.getParent(); parent != null; parent = parent.getParent()) {
            UnixFileAttributes attrs = null;
            try {
                attrs = UnixFileAttributes.get(parent, true);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(parent);
            }
            if (attrs.dev() != this.dev()) break;
            path = parent;
        }
        byte[] dir = path.asByteArray();
        for (UnixMountEntry entry : fs.getMountEntries()) {
            if (!Arrays.equals(dir, entry.dir())) continue;
            return entry;
        }
        throw new IOException("Mount point not found");
    }

    @Override
    protected boolean isExtendedAttributesEnabled(UnixPath path) {
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return super.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return super.supportsFileAttributeView(name);
    }
}

