/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import sun.nio.fs.BsdNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;
import sun.security.action.GetPropertyAction;

class BsdFileStore
extends UnixFileStore {
    BsdFileStore(UnixPath file) throws IOException {
        super(file);
    }

    BsdFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        super(fs, entry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        UnixFileSystem fs = this.file().getFileSystem();
        UnixPath path = null;
        try {
            byte[] rp = UnixNativeDispatcher.realpath(this.file());
            path = new UnixPath(fs, rp);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file());
        }
        byte[] dir = null;
        try {
            dir = BsdNativeDispatcher.getmntonname(path);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(path);
        }
        for (UnixMountEntry entry : fs.getMountEntries()) {
            if (!Arrays.equals(dir, entry.dir())) continue;
            return entry;
        }
        throw new IOException("Mount point not found in fstab");
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        if (type == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus status = this.checkIfFeaturePresent("user_xattr");
            if (status == UnixFileStore.FeatureStatus.PRESENT) {
                return true;
            }
            if (status == UnixFileStore.FeatureStatus.NOT_PRESENT) {
                return false;
            }
            String fstype = this.entry().fstype();
            if ("hfs".equals(fstype)) {
                return true;
            }
            if ("apfs".equals(fstype)) {
                return BsdFileStore.isOsVersionGte(10, 14);
            }
            UnixPath dir = new UnixPath(this.file().getFileSystem(), this.entry().dir());
            return this.isExtendedAttributesEnabled(dir);
        }
        return super.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (name.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(name);
    }

    private static boolean isOsVersionGte(int requiredMajor, int requiredMinor) {
        String osVersion = GetPropertyAction.privilegedGetProperty("os.version");
        String[] vers = Util.split(osVersion, '.');
        int majorVersion = Integer.parseInt(vers[0]);
        int minorVersion = Integer.parseInt(vers[1]);
        return majorVersion > requiredMajor || majorVersion == requiredMajor && minorVersion >= requiredMinor;
    }
}

