/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import sun.nio.fs.BsdFileStore;
import sun.nio.fs.BsdFileSystem;
import sun.nio.fs.BsdUserDefinedFileAttributeView;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class BsdFileSystemProvider
extends UnixFileSystemProvider {
    @Override
    BsdFileSystem newFileSystem(String dir) {
        return new BsdFileSystem(this, dir);
    }

    @Override
    BsdFileStore getFileStore(UnixPath path) throws IOException {
        return new BsdFileStore(path);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path obj, Class<V> type, LinkOption ... options) {
        if (type == UserDefinedFileAttributeView.class) {
            return (V)new BsdUserDefinedFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        return super.getFileAttributeView(obj, type, options);
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path obj, String name, LinkOption ... options) {
        if (name.equals("user")) {
            return new BsdUserDefinedFileAttributeView(UnixPath.toUnixPath(obj), Util.followLinks(options));
        }
        return super.getFileAttributeView(obj, name, options);
    }
}

