/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.FileSystem;
import java.nio.file.spi.FileSystemProvider;
import org.qbicc.runtime.Build;
import sun.nio.fs.AixFileSystemProvider;
import sun.nio.fs.LinuxFileSystemProvider;
import sun.nio.fs.MacOSXFileSystemProvider;
import sun.nio.fs.WindowsFileSystemProvider;

public class DefaultFileSystemProvider {
    private static final FileSystemProvider INSTANCE;
    private static final FileSystem THE_FILE_SYSTEM;

    private DefaultFileSystemProvider() {
    }

    public static FileSystemProvider instance() {
        return INSTANCE;
    }

    public static FileSystem theFileSystem() {
        return THE_FILE_SYSTEM;
    }

    static {
        if (Build.Target.isAix()) {
            AixFileSystemProvider provider = new AixFileSystemProvider();
            INSTANCE = provider;
            THE_FILE_SYSTEM = provider.theFileSystem();
        } else if (Build.Target.isLinux()) {
            LinuxFileSystemProvider provider = new LinuxFileSystemProvider();
            INSTANCE = provider;
            THE_FILE_SYSTEM = provider.theFileSystem();
        } else if (Build.Target.isMacOs()) {
            MacOSXFileSystemProvider provider = new MacOSXFileSystemProvider();
            INSTANCE = provider;
            THE_FILE_SYSTEM = provider.theFileSystem();
        } else if (Build.Target.isWindows()) {
            WindowsFileSystemProvider provider = new WindowsFileSystemProvider();
            INSTANCE = provider;
            THE_FILE_SYSTEM = provider.theFileSystem();
        } else {
            throw new Error();
        }
    }
}

