/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class LinuxFileStore
extends UnixFileStore {
    private volatile boolean xattrChecked;
    private volatile boolean xattrEnabled;

    LinuxFileStore(UnixPath file) throws IOException {
        super(file);
    }

    LinuxFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        super(fs, entry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        LinuxFileSystem fs = (LinuxFileSystem)this.file().getFileSystem();
        UnixPath path = null;
        try {
            byte[] rp = UnixNativeDispatcher.realpath(this.file());
            path = new UnixPath((UnixFileSystem)fs, rp);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file());
        }
        List<UnixMountEntry> procMountsEntries = fs.getMountEntries("/proc/mounts");
        for (UnixPath parent = path.getParent(); parent != null; parent = parent.getParent()) {
            UnixFileAttributes attrs = null;
            try {
                attrs = UnixFileAttributes.get(parent, true);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(parent);
            }
            if (attrs.dev() != this.dev()) {
                byte[] dir = path.asByteArray();
                for (UnixMountEntry entry : procMountsEntries) {
                    if (!Arrays.equals(dir, entry.dir())) continue;
                    return entry;
                }
            }
            path = parent;
        }
        byte[] dir = path.asByteArray();
        for (UnixMountEntry entry : procMountsEntries) {
            if (!Arrays.equals(dir, entry.dir())) continue;
            return entry;
        }
        throw new IOException("Mount point not found");
    }

    private static int[] getKernelVersion() {
        Pattern pattern = Pattern.compile("\\D+");
        String[] matches = pattern.split(System.getProperty("os.version"));
        int[] majorMinorMicro = new int[3];
        int length = Math.min(matches.length, majorMinorMicro.length);
        for (int i = 0; i < length; ++i) {
            majorMinorMicro[i] = Integer.valueOf(matches[i]);
        }
        return majorMinorMicro;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        if (type == DosFileAttributeView.class || type == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus status = this.checkIfFeaturePresent("user_xattr");
            if (status == UnixFileStore.FeatureStatus.PRESENT) {
                return true;
            }
            if (status == UnixFileStore.FeatureStatus.NOT_PRESENT) {
                return false;
            }
            if (this.entry().hasOption("user_xattr")) {
                return true;
            }
            if (this.entry().hasOption("nouser_xattr")) {
                return false;
            }
            if (this.entry().fstype().equals("ext4")) {
                if (!this.xattrChecked) {
                    int[] kernelVersion = LinuxFileStore.getKernelVersion();
                    this.xattrEnabled = kernelVersion[0] > 2 || kernelVersion[0] == 2 && kernelVersion[1] > 6 || kernelVersion[0] == 2 && kernelVersion[1] == 6 && kernelVersion[2] >= 39;
                    this.xattrChecked = true;
                }
                return this.xattrEnabled;
            }
            if (!this.xattrChecked) {
                UnixPath dir = new UnixPath(this.file().getFileSystem(), this.entry().dir());
                this.xattrEnabled = this.isExtendedAttributesEnabled(dir);
                this.xattrChecked = true;
            }
            return this.xattrEnabled;
        }
        if (type == PosixFileAttributeView.class && this.entry().fstype().equals("vfat")) {
            return false;
        }
        return super.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (name.equals("dos")) {
            return this.supportsFileAttributeView(DosFileAttributeView.class);
        }
        if (name.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(name);
    }
}

