/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import jdk.internal.loader.BootLoader;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

public class RegistryFileTypeDetector
extends AbstractFileTypeDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String implProbeContentType(Path file) throws IOException {
        if (!(file instanceof Path)) {
            return null;
        }
        Path name = file.getFileName();
        if (name == null) {
            return null;
        }
        String filename = name.toString();
        int dot = filename.lastIndexOf(46);
        if (dot < 0 || dot == filename.length() - 1) {
            return null;
        }
        String key = filename.substring(dot);
        NativeBuffer keyBuffer = null;
        NativeBuffer nameBuffer = null;
        try {
            keyBuffer = WindowsNativeDispatcher.asNativeBuffer(key);
            nameBuffer = WindowsNativeDispatcher.asNativeBuffer("Content Type");
            String string = RegistryFileTypeDetector.queryStringValue(keyBuffer.address(), nameBuffer.address());
            return string;
        }
        catch (WindowsException we) {
            we.rethrowAsIOException(file.toString());
            String string = null;
            return string;
        }
        finally {
            nameBuffer.release();
            keyBuffer.release();
        }
    }

    private static native String queryStringValue(long var0, long var2);

    static {
        BootLoader.loadLibrary("net");
        BootLoader.loadLibrary("nio");
    }
}

