/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class UnixException
extends Exception {
    static final long serialVersionUID = 7227016794320723218L;
    private int errno;
    private String msg;

    UnixException(int errno) {
        this.errno = errno;
        this.msg = null;
    }

    UnixException(String msg) {
        this.errno = 0;
        this.msg = msg;
    }

    int errno() {
        return this.errno;
    }

    void setError(int errno) {
        this.errno = errno;
        this.msg = null;
    }

    String errorString() {
        if (this.msg != null) {
            return this.msg;
        }
        return Util.toString(UnixNativeDispatcher.strerror(this.errno()));
    }

    @Override
    public String getMessage() {
        return this.errorString();
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    private IOException translateToIOException(String file, String other) {
        if (this.msg != null) {
            return new IOException(this.msg);
        }
        if (this.errno() == UnixConstants.EACCES) {
            return new AccessDeniedException(file, other, null);
        }
        if (this.errno() == UnixConstants.ENOENT) {
            return new NoSuchFileException(file, other, null);
        }
        if (this.errno() == UnixConstants.EEXIST) {
            return new FileAlreadyExistsException(file, other, null);
        }
        if (this.errno() == UnixConstants.ELOOP) {
            return new FileSystemException(file, other, this.errorString() + " or unable to access attributes of symbolic link");
        }
        return new FileSystemException(file, other, this.errorString());
    }

    void rethrowAsIOException(UnixPath file, UnixPath other) throws IOException {
        String a = file == null ? null : file.getPathForExceptionMessage();
        String b = other == null ? null : other.getPathForExceptionMessage();
        IOException x = this.translateToIOException(a, b);
        throw x;
    }

    void rethrowAsIOException(UnixPath file) throws IOException {
        this.rethrowAsIOException(file, null);
    }

    IOException asIOException(UnixPath file) {
        return this.translateToIOException(file.getPathForExceptionMessage(), null);
    }
}

