/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileKey;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

class UnixFileAttributes
implements PosixFileAttributes {
    private int st_mode;
    private long st_ino;
    private long st_dev;
    private long st_rdev;
    private int st_nlink;
    private int st_uid;
    private int st_gid;
    private long st_size;
    private long st_atime_sec;
    private long st_atime_nsec;
    private long st_mtime_sec;
    private long st_mtime_nsec;
    private long st_ctime_sec;
    private long st_ctime_nsec;
    private long st_birthtime_sec;
    private volatile UserPrincipal owner;
    private volatile GroupPrincipal group;
    private volatile UnixFileKey key;

    private UnixFileAttributes() {
    }

    static UnixFileAttributes get(UnixPath path, boolean followLinks) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        if (followLinks) {
            UnixNativeDispatcher.stat(path, attrs);
        } else {
            UnixNativeDispatcher.lstat(path, attrs);
        }
        return attrs;
    }

    static UnixFileAttributes get(int fd) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        UnixNativeDispatcher.fstat(fd, attrs);
        return attrs;
    }

    static UnixFileAttributes get(int dfd, UnixPath path, boolean followLinks) throws UnixException {
        UnixFileAttributes attrs = new UnixFileAttributes();
        int flag = followLinks ? 0 : UnixConstants.AT_SYMLINK_NOFOLLOW;
        UnixNativeDispatcher.fstatat(dfd, path.asByteArray(), flag, attrs);
        return attrs;
    }

    boolean isSameFile(UnixFileAttributes attrs) {
        return this.st_ino == attrs.st_ino && this.st_dev == attrs.st_dev;
    }

    int mode() {
        return this.st_mode;
    }

    long ino() {
        return this.st_ino;
    }

    long dev() {
        return this.st_dev;
    }

    long rdev() {
        return this.st_rdev;
    }

    int nlink() {
        return this.st_nlink;
    }

    int uid() {
        return this.st_uid;
    }

    int gid() {
        return this.st_gid;
    }

    private static FileTime toFileTime(long sec, long nsec) {
        if (nsec == 0L) {
            return FileTime.from(sec, TimeUnit.SECONDS);
        }
        try {
            long nanos = Math.addExact(nsec, Math.multiplyExact(sec, 1000000000L));
            return FileTime.from(nanos, TimeUnit.NANOSECONDS);
        }
        catch (ArithmeticException ignore) {
            long micro = sec * 1000000L + nsec / 1000L;
            return FileTime.from(micro, TimeUnit.MICROSECONDS);
        }
    }

    FileTime ctime() {
        return UnixFileAttributes.toFileTime(this.st_ctime_sec, this.st_ctime_nsec);
    }

    boolean isDevice() {
        int type = this.st_mode & UnixConstants.S_IFMT;
        return type == UnixConstants.S_IFCHR || type == UnixConstants.S_IFBLK || type == UnixConstants.S_IFIFO;
    }

    @Override
    public FileTime lastModifiedTime() {
        return UnixFileAttributes.toFileTime(this.st_mtime_sec, this.st_mtime_nsec);
    }

    @Override
    public FileTime lastAccessTime() {
        return UnixFileAttributes.toFileTime(this.st_atime_sec, this.st_atime_nsec);
    }

    @Override
    public FileTime creationTime() {
        if (UnixNativeDispatcher.birthtimeSupported()) {
            return FileTime.from(this.st_birthtime_sec, TimeUnit.SECONDS);
        }
        return this.lastModifiedTime();
    }

    @Override
    public boolean isRegularFile() {
        return (this.st_mode & UnixConstants.S_IFMT) == UnixConstants.S_IFREG;
    }

    @Override
    public boolean isDirectory() {
        return (this.st_mode & UnixConstants.S_IFMT) == UnixConstants.S_IFDIR;
    }

    @Override
    public boolean isSymbolicLink() {
        return (this.st_mode & UnixConstants.S_IFMT) == UnixConstants.S_IFLNK;
    }

    @Override
    public boolean isOther() {
        int type = this.st_mode & UnixConstants.S_IFMT;
        return type != UnixConstants.S_IFREG && type != UnixConstants.S_IFDIR && type != UnixConstants.S_IFLNK;
    }

    @Override
    public long size() {
        return this.st_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnixFileKey fileKey() {
        if (this.key == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.key == null) {
                    this.key = new UnixFileKey(this.st_dev, this.st_ino);
                }
            }
        }
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal owner() {
        if (this.owner == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.owner == null) {
                    this.owner = UnixUserPrincipals.fromUid(this.st_uid);
                }
            }
        }
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupPrincipal group() {
        if (this.group == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.group == null) {
                    this.group = UnixUserPrincipals.fromGid(this.st_gid);
                }
            }
        }
        return this.group;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        int bits = this.st_mode & UnixConstants.S_IAMB;
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((bits & UnixConstants.S_IRUSR) > 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((bits & UnixConstants.S_IWUSR) > 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((bits & UnixConstants.S_IXUSR) > 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((bits & UnixConstants.S_IRGRP) > 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((bits & UnixConstants.S_IWGRP) > 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((bits & UnixConstants.S_IXGRP) > 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((bits & UnixConstants.S_IROTH) > 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((bits & UnixConstants.S_IWOTH) > 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((bits & UnixConstants.S_IXOTH) > 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    BasicFileAttributes asBasicFileAttributes() {
        return UnixAsBasicFileAttributes.wrap(this);
    }

    static UnixFileAttributes toUnixFileAttributes(BasicFileAttributes attrs) {
        if (attrs instanceof UnixFileAttributes) {
            return (UnixFileAttributes)attrs;
        }
        if (attrs instanceof UnixAsBasicFileAttributes) {
            return ((UnixAsBasicFileAttributes)attrs).unwrap();
        }
        return null;
    }

    private static class UnixAsBasicFileAttributes
    implements BasicFileAttributes {
        private final UnixFileAttributes attrs;

        private UnixAsBasicFileAttributes(UnixFileAttributes attrs) {
            this.attrs = attrs;
        }

        static UnixAsBasicFileAttributes wrap(UnixFileAttributes attrs) {
            return new UnixAsBasicFileAttributes(attrs);
        }

        UnixFileAttributes unwrap() {
            return this.attrs;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.attrs.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.attrs.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.attrs.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.attrs.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.attrs.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.attrs.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return this.attrs.isOther();
        }

        @Override
        public long size() {
            return this.attrs.size();
        }

        @Override
        public Object fileKey() {
            return this.attrs.fileKey();
        }
    }
}

