/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.List;
import jdk.internal.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

abstract class UnixUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_NAMESPACE = "user.";
    private static final int MIN_LISTXATTR_BUF_SIZE = 1024;
    private static final int MAX_LISTXATTR_BUF_SIZE = 32768;
    private final UnixPath file;
    private final boolean followLinks;

    UnixUserDefinedFileAttributeView(UnixPath file, boolean followLinks) {
        this.file = file;
        this.followLinks = followLinks;
    }

    private byte[] nameAsBytes(UnixPath file, String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("'name' is null");
        }
        name = USER_NAMESPACE + name;
        byte[] bytes = Util.toBytes(name);
        if (bytes.length > this.maxNameLength()) {
            throw new FileSystemException(file.getPathForExceptionMessage(), null, "'" + name + "' is too big");
        }
        return bytes;
    }

    protected abstract int maxNameLength();

    private static List<String> asList(long address, int size) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        for (int pos = 0; pos < size; ++pos) {
            if (unsafe.getByte(address + (long)pos) != 0) continue;
            int len = pos - start;
            byte[] value = new byte[len];
            unsafe.copyMemory(null, address + (long)start, value, Unsafe.ARRAY_BYTE_BASE_OFFSET, len);
            String s = Util.toString(value);
            list.add(s);
            start = pos + 1;
        }
        return list;
    }

    private static List<String> list(int fd, int bufSize) throws UnixException {
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(bufSize);
        try {
            int n = UnixNativeDispatcher.flistxattr(fd, buffer.address(), bufSize);
            List<String> list = UnixUserDefinedFileAttributeView.asList(buffer.address(), n);
            if (buffer != null) {
                buffer.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (UnixException x) {
                if (x.errno() == UnixConstants.ERANGE && bufSize < 32768) {
                    return UnixUserDefinedFileAttributeView.list(fd, bufSize * 2);
                }
                throw x;
            }
        }
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int fd = -1;
        try {
            fd = this.file.openForAttributeAccess(this.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            List<String> attrNames = UnixUserDefinedFileAttributeView.list(fd, 1024);
            List<String> list = attrNames.stream().filter(s -> s.startsWith(USER_NAMESPACE)).map(s -> s.substring(USER_NAMESPACE.length())).toList();
            return list;
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get list of extended attributes: " + x.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    @Override
    public int size(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        int fd = -1;
        try {
            fd = this.file.openForAttributeAccess(this.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            int x = UnixNativeDispatcher.fgetxattr(fd, this.nameAsBytes(this.file, name), 0L, 0);
            return x;
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to get size of extended attribute '" + name + "': " + x.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String name, ByteBuffer dst) throws IOException {
        int rem;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer) {
            DirectBuffer buf = (DirectBuffer)((Object)dst);
            try {
                long address = buf.address() + (long)pos;
                int n2 = this.read(name, address, rem);
                dst.position(pos + n2);
                int n3 = n2;
                return n3;
            }
            finally {
                Reference.reachabilityFence(buf);
            }
        }
        try (NativeBuffer nb = NativeBuffers.getNativeBuffer(rem);){
            long address = nb.address();
            int n4 = this.read(name, address, rem);
            int off = dst.arrayOffset() + pos + Unsafe.ARRAY_BYTE_BASE_OFFSET;
            unsafe.copyMemory(null, address, dst.array(), off, n4);
            dst.position(pos + n4);
            int n5 = n4;
            return n5;
        }
    }

    private int read(String name, long address, int rem) throws IOException {
        int fd = -1;
        try {
            fd = this.file.openForAttributeAccess(this.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            int n = UnixNativeDispatcher.fgetxattr(fd, this.nameAsBytes(this.file, name), address, rem);
            if (rem == 0) {
                if (n > 0) {
                    throw new UnixException(UnixConstants.ERANGE);
                }
                int n2 = 0;
                return n2;
            }
            int n3 = n;
            return n3;
        }
        catch (UnixException x) {
            String msg = x.errno() == UnixConstants.ERANGE ? "Insufficient space in buffer" : x.getMessage();
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error reading extended attribute '" + name + "': " + msg);
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String name, ByteBuffer src) throws IOException {
        int rem;
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (src instanceof DirectBuffer) {
            DirectBuffer buf = (DirectBuffer)((Object)src);
            try {
                long address = buf.address() + (long)pos;
                this.write(name, address, rem);
                src.position(pos + rem);
                int n2 = rem;
                return n2;
            }
            finally {
                Reference.reachabilityFence(buf);
            }
        }
        try (NativeBuffer nb = NativeBuffers.getNativeBuffer(rem);){
            long address = nb.address();
            if (src.hasArray()) {
                int off = src.arrayOffset() + pos + Unsafe.ARRAY_BYTE_BASE_OFFSET;
                unsafe.copyMemory(src.array(), off, null, address, rem);
            } else {
                byte[] tmp = new byte[rem];
                src.get(tmp);
                src.position(pos);
                unsafe.copyMemory(tmp, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, address, rem);
            }
            this.write(name, address, rem);
            src.position(pos + rem);
            int n3 = rem;
            return n3;
        }
    }

    private void write(String name, long address, int rem) throws IOException {
        int fd = -1;
        try {
            fd = this.file.openForAttributeAccess(this.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            UnixNativeDispatcher.fsetxattr(fd, this.nameAsBytes(this.file, name), address, rem);
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Error writing extended attribute '" + name + "': " + x.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    @Override
    public void delete(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        int fd = -1;
        try {
            fd = this.file.openForAttributeAccess(this.followLinks);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            UnixNativeDispatcher.fremovexattr(fd, this.nameAsBytes(this.file, name));
        }
        catch (UnixException x) {
            throw new FileSystemException(this.file.getPathForExceptionMessage(), null, "Unable to delete extended attribute '" + name + "': " + x.getMessage());
        }
        finally {
            UnixNativeDispatcher.close(fd);
        }
    }

    static void copyExtendedAttributes(int ofd, int nfd) {
        try {
            List<String> attrNames = UnixUserDefinedFileAttributeView.list(ofd, 1024);
            for (String name : attrNames) {
                try {
                    UnixUserDefinedFileAttributeView.copyExtendedAttribute(ofd, Util.toBytes(name), nfd);
                }
                catch (UnixException unixException) {}
            }
        }
        catch (UnixException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyExtendedAttribute(int ofd, byte[] name, int nfd) throws UnixException {
        int size = UnixNativeDispatcher.fgetxattr(ofd, name, 0L, 0);
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(size);
        try {
            long address = buffer.address();
            size = UnixNativeDispatcher.fgetxattr(ofd, name, address, size);
            UnixNativeDispatcher.fsetxattr(nfd, name, address, size);
        }
        finally {
            buffer.release();
        }
    }
}

