/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsFileAttributeViews {
    WindowsFileAttributeViews() {
    }

    static Basic createBasicView(WindowsPath file, boolean followLinks) {
        return new Basic(file, followLinks);
    }

    static Dos createDosView(WindowsPath file, boolean followLinks) {
        return new Dos(file, followLinks);
    }

    private static class Basic
    extends AbstractBasicFileAttributeView {
        final WindowsPath file;
        final boolean followLinks;

        Basic(WindowsPath file, boolean followLinks) {
            this.file = file;
            this.followLinks = followLinks;
        }

        @Override
        public WindowsFileAttributes readAttributes() throws IOException {
            this.file.checkRead();
            try {
                return WindowsFileAttributes.get(this.file, this.followLinks);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.file);
                return null;
            }
        }

        private long adjustForFatEpoch(long time) {
            long FAT_EPOCH = 119600064000000000L;
            if (time != -1L && time < 119600064000000000L) {
                return 119600064000000000L;
            }
            return time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFileTimes(long createTime, long lastAccessTime, long lastWriteTime) throws IOException {
            long handle = -1L;
            try {
                int flags = 0x2000000;
                if (!this.followLinks) {
                    flags |= 0x200000;
                }
                handle = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), 256, 7, 3, flags);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.file);
            }
            try {
                WindowsNativeDispatcher.SetFileTime(handle, createTime, lastAccessTime, lastWriteTime);
            }
            catch (WindowsException x2) {
                Object x2;
                if (this.followLinks && x2.lastError() == 87) {
                    try {
                        if (WindowsFileStore.create(this.file).type().equals("FAT")) {
                            WindowsNativeDispatcher.SetFileTime(handle, this.adjustForFatEpoch(createTime), this.adjustForFatEpoch(lastAccessTime), this.adjustForFatEpoch(lastWriteTime));
                            x2 = null;
                        }
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (WindowsException windowsException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (x2 != null) {
                    x2.rethrowAsIOException(this.file);
                }
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(handle);
            }
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            if (lastModifiedTime == null && lastAccessTime == null && createTime == null) {
                return;
            }
            this.file.checkWrite();
            long t1 = createTime == null ? -1L : WindowsFileAttributes.toWindowsTime(createTime);
            long t2 = lastAccessTime == null ? -1L : WindowsFileAttributes.toWindowsTime(lastAccessTime);
            long t3 = lastModifiedTime == null ? -1L : WindowsFileAttributes.toWindowsTime(lastModifiedTime);
            this.setFileTimes(t1, t2, t3);
        }
    }

    static class Dos
    extends Basic
    implements DosFileAttributeView {
        private static final String READONLY_NAME = "readonly";
        private static final String ARCHIVE_NAME = "archive";
        private static final String SYSTEM_NAME = "system";
        private static final String HIDDEN_NAME = "hidden";
        private static final String ATTRIBUTES_NAME = "attributes";
        static final Set<String> dosAttributeNames = Util.newSet(basicAttributeNames, new String[]{"readonly", "archive", "system", "hidden", "attributes"});

        Dos(WindowsPath file, boolean followLinks) {
            super(file, followLinks);
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public void setAttribute(String attribute, Object value) throws IOException {
            if (attribute.equals(READONLY_NAME)) {
                this.setReadOnly((Boolean)value);
                return;
            }
            if (attribute.equals(ARCHIVE_NAME)) {
                this.setArchive((Boolean)value);
                return;
            }
            if (attribute.equals(SYSTEM_NAME)) {
                this.setSystem((Boolean)value);
                return;
            }
            if (attribute.equals(HIDDEN_NAME)) {
                this.setHidden((Boolean)value);
                return;
            }
            super.setAttribute(attribute, value);
        }

        @Override
        public Map<String, Object> readAttributes(String[] attributes) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder builder = AbstractBasicFileAttributeView.AttributesBuilder.create(dosAttributeNames, attributes);
            DosFileAttributes attrs = this.readAttributes();
            this.addRequestedBasicAttributes(attrs, builder);
            if (builder.match(READONLY_NAME)) {
                builder.add(READONLY_NAME, ((WindowsFileAttributes)attrs).isReadOnly());
            }
            if (builder.match(ARCHIVE_NAME)) {
                builder.add(ARCHIVE_NAME, ((WindowsFileAttributes)attrs).isArchive());
            }
            if (builder.match(SYSTEM_NAME)) {
                builder.add(SYSTEM_NAME, ((WindowsFileAttributes)attrs).isSystem());
            }
            if (builder.match(HIDDEN_NAME)) {
                builder.add(HIDDEN_NAME, ((WindowsFileAttributes)attrs).isHidden());
            }
            if (builder.match(ATTRIBUTES_NAME)) {
                builder.add(ATTRIBUTES_NAME, ((WindowsFileAttributes)attrs).attributes());
            }
            return builder.unmodifiableMap();
        }

        private void updateAttributes(int flag, boolean enable) throws IOException {
            this.file.checkWrite();
            String path = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
            try {
                int oldValue;
                int newValue = oldValue = WindowsNativeDispatcher.GetFileAttributes(path);
                newValue = enable ? (newValue |= flag) : (newValue &= ~flag);
                if (newValue != oldValue) {
                    WindowsNativeDispatcher.SetFileAttributes(path, newValue);
                }
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.file);
            }
        }

        @Override
        public void setReadOnly(boolean value) throws IOException {
            this.updateAttributes(1, value);
        }

        @Override
        public void setHidden(boolean value) throws IOException {
            this.updateAttributes(2, value);
        }

        @Override
        public void setArchive(boolean value) throws IOException {
            this.updateAttributes(32, value);
        }

        @Override
        public void setSystem(boolean value) throws IOException {
            this.updateAttributes(4, value);
        }

        void setAttributes(WindowsFileAttributes attrs) throws IOException {
            int flags = 0;
            if (attrs.isReadOnly()) {
                flags |= 1;
            }
            if (attrs.isHidden()) {
                flags |= 2;
            }
            if (attrs.isArchive()) {
                flags |= 0x20;
            }
            if (attrs.isSystem()) {
                flags |= 4;
            }
            this.updateAttributes(flags, true);
            this.setFileTimes(WindowsFileAttributes.toWindowsTime(attrs.creationTime()), WindowsFileAttributes.toWindowsTime(attrs.lastModifiedTime()), WindowsFileAttributes.toWindowsTime(attrs.lastAccessTime()));
        }
    }
}

