/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import jdk.internal.loader.BootLoader;
import jdk.internal.misc.Unsafe;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;

class WindowsNativeDispatcher {
    private static final Unsafe unsafe = Unsafe.getUnsafe();

    private WindowsNativeDispatcher() {
    }

    static native long CreateEvent(boolean var0, boolean var1) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long CreateFile(String path, int dwDesiredAccess, int dwShareMode, long lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            long l = WindowsNativeDispatcher.CreateFile0(buffer.address(), dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes);
            return l;
        }
        finally {
            buffer.release();
        }
    }

    static long CreateFile(String path, int dwDesiredAccess, int dwShareMode, int dwCreationDisposition, int dwFlagsAndAttributes) throws WindowsException {
        return WindowsNativeDispatcher.CreateFile(path, dwDesiredAccess, dwShareMode, 0L, dwCreationDisposition, dwFlagsAndAttributes);
    }

    private static native long CreateFile0(long var0, int var2, int var3, long var4, int var6, int var7) throws WindowsException;

    static native void CloseHandle(long var0);

    static void DeleteFile(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.DeleteFile0(buffer.address());
        }
        finally {
            buffer.release();
        }
    }

    private static native void DeleteFile0(long var0) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void CreateDirectory(String path, long lpSecurityAttributes) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.CreateDirectory0(buffer.address(), lpSecurityAttributes);
        }
        finally {
            buffer.release();
        }
    }

    private static native void CreateDirectory0(long var0, long var2) throws WindowsException;

    static void RemoveDirectory(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.RemoveDirectory0(buffer.address());
        }
        finally {
            buffer.release();
        }
    }

    private static native void RemoveDirectory0(long var0) throws WindowsException;

    static native void DeviceIoControlSetSparse(long var0) throws WindowsException;

    static native void DeviceIoControlGetReparsePoint(long var0, long var2, int var4) throws WindowsException;

    static native long GetFileSizeEx(long var0) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FirstFile FindFirstFile(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            FirstFile data = new FirstFile();
            WindowsNativeDispatcher.FindFirstFile0(buffer.address(), data);
            FirstFile firstFile = data;
            return firstFile;
        }
        finally {
            buffer.release();
        }
    }

    private static native void FindFirstFile0(long var0, FirstFile var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long FindFirstFile(String path, long address) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            long l = WindowsNativeDispatcher.FindFirstFile1(buffer.address(), address);
            return l;
        }
        finally {
            buffer.release();
        }
    }

    private static native long FindFirstFile1(long var0, long var2) throws WindowsException;

    static native String FindNextFile(long var0, long var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FirstStream FindFirstStream(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            FirstStream data = new FirstStream();
            WindowsNativeDispatcher.FindFirstStream0(buffer.address(), data);
            if (data.handle() == -1L) {
                FirstStream firstStream = null;
                return firstStream;
            }
            FirstStream firstStream = data;
            return firstStream;
        }
        finally {
            buffer.release();
        }
    }

    private static native void FindFirstStream0(long var0, FirstStream var2) throws WindowsException;

    static native String FindNextStream(long var0) throws WindowsException;

    static native void FindClose(long var0) throws WindowsException;

    static native void GetFileInformationByHandle(long var0, long var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void CopyFileEx(String source, String target, int flags, long addressToPollForCancel) throws WindowsException {
        NativeBuffer sourceBuffer = WindowsNativeDispatcher.asNativeBuffer(source);
        NativeBuffer targetBuffer = WindowsNativeDispatcher.asNativeBuffer(target);
        try {
            WindowsNativeDispatcher.CopyFileEx0(sourceBuffer.address(), targetBuffer.address(), flags, addressToPollForCancel);
        }
        finally {
            targetBuffer.release();
            sourceBuffer.release();
        }
    }

    private static native void CopyFileEx0(long var0, long var2, int var4, long var5) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void MoveFileEx(String source, String target, int flags) throws WindowsException {
        NativeBuffer sourceBuffer = WindowsNativeDispatcher.asNativeBuffer(source);
        NativeBuffer targetBuffer = WindowsNativeDispatcher.asNativeBuffer(target);
        try {
            WindowsNativeDispatcher.MoveFileEx0(sourceBuffer.address(), targetBuffer.address(), flags);
        }
        finally {
            targetBuffer.release();
            sourceBuffer.release();
        }
    }

    private static native void MoveFileEx0(long var0, long var2, int var4) throws WindowsException;

    static int GetFileAttributes(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            int n = WindowsNativeDispatcher.GetFileAttributes0(buffer.address());
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int GetFileAttributes0(long var0) throws WindowsException;

    static void SetFileAttributes(String path, int dwFileAttributes) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.SetFileAttributes0(buffer.address(), dwFileAttributes);
        }
        finally {
            buffer.release();
        }
    }

    private static native void SetFileAttributes0(long var0, int var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void GetFileAttributesEx(String path, long address) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.GetFileAttributesEx0(buffer.address(), address);
        }
        finally {
            buffer.release();
        }
    }

    private static native void GetFileAttributesEx0(long var0, long var2) throws WindowsException;

    static native void SetFileTime(long var0, long var2, long var4, long var6) throws WindowsException;

    static native void SetEndOfFile(long var0) throws WindowsException;

    static native int GetLogicalDrives() throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VolumeInformation GetVolumeInformation(String root) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(root);
        try {
            VolumeInformation info = new VolumeInformation();
            WindowsNativeDispatcher.GetVolumeInformation0(buffer.address(), info);
            VolumeInformation volumeInformation = info;
            return volumeInformation;
        }
        finally {
            buffer.release();
        }
    }

    private static native void GetVolumeInformation0(long var0, VolumeInformation var2) throws WindowsException;

    static int GetDriveType(String root) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(root);
        try {
            int n = WindowsNativeDispatcher.GetDriveType0(buffer.address());
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int GetDriveType0(long var0) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DiskFreeSpace GetDiskFreeSpaceEx(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            DiskFreeSpace space = new DiskFreeSpace();
            WindowsNativeDispatcher.GetDiskFreeSpaceEx0(buffer.address(), space);
            DiskFreeSpace diskFreeSpace = space;
            return diskFreeSpace;
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DiskFreeSpace GetDiskFreeSpace(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            DiskFreeSpace space = new DiskFreeSpace();
            WindowsNativeDispatcher.GetDiskFreeSpace0(buffer.address(), space);
            DiskFreeSpace diskFreeSpace = space;
            return diskFreeSpace;
        }
        finally {
            buffer.release();
        }
    }

    private static native void GetDiskFreeSpaceEx0(long var0, DiskFreeSpace var2) throws WindowsException;

    private static native void GetDiskFreeSpace0(long var0, DiskFreeSpace var2) throws WindowsException;

    static String GetVolumePathName(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            String string = WindowsNativeDispatcher.GetVolumePathName0(buffer.address());
            return string;
        }
        finally {
            buffer.release();
        }
    }

    private static native String GetVolumePathName0(long var0) throws WindowsException;

    static native void InitializeSecurityDescriptor(long var0) throws WindowsException;

    static native void InitializeAcl(long var0, int var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int GetFileSecurity(String path, int requestedInformation, long pSecurityDescriptor, int nLength) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            int n = WindowsNativeDispatcher.GetFileSecurity0(buffer.address(), requestedInformation, pSecurityDescriptor, nLength);
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int GetFileSecurity0(long var0, int var2, long var3, int var5) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void SetFileSecurity(String path, int securityInformation, long pSecurityDescriptor) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            WindowsNativeDispatcher.SetFileSecurity0(buffer.address(), securityInformation, pSecurityDescriptor);
        }
        finally {
            buffer.release();
        }
    }

    static native void SetFileSecurity0(long var0, int var2, long var3) throws WindowsException;

    static native long GetSecurityDescriptorOwner(long var0) throws WindowsException;

    static native void SetSecurityDescriptorOwner(long var0, long var2) throws WindowsException;

    static native long GetSecurityDescriptorDacl(long var0);

    static native void SetSecurityDescriptorDacl(long var0, long var2) throws WindowsException;

    static AclInformation GetAclInformation(long aclAddress) {
        AclInformation info = new AclInformation();
        WindowsNativeDispatcher.GetAclInformation0(aclAddress, info);
        return info;
    }

    private static native void GetAclInformation0(long var0, AclInformation var2);

    static native long GetAce(long var0, int var2);

    static native void AddAccessAllowedAceEx(long var0, int var2, int var3, long var4) throws WindowsException;

    static native void AddAccessDeniedAceEx(long var0, int var2, int var3, long var4) throws WindowsException;

    static Account LookupAccountSid(long sidAddress) throws WindowsException {
        Account acc = new Account();
        WindowsNativeDispatcher.LookupAccountSid0(sidAddress, acc);
        return acc;
    }

    private static native void LookupAccountSid0(long var0, Account var2) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int LookupAccountName(String accountName, long pSid, int cbSid) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(accountName);
        try {
            int n = WindowsNativeDispatcher.LookupAccountName0(buffer.address(), pSid, cbSid);
            return n;
        }
        finally {
            buffer.release();
        }
    }

    private static native int LookupAccountName0(long var0, long var2, int var4) throws WindowsException;

    static native int GetLengthSid(long var0);

    static native String ConvertSidToStringSid(long var0) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long ConvertStringSidToSid(String sidString) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(sidString);
        try {
            long l = WindowsNativeDispatcher.ConvertStringSidToSid0(buffer.address());
            return l;
        }
        finally {
            buffer.release();
        }
    }

    private static native long ConvertStringSidToSid0(long var0) throws WindowsException;

    static native long GetCurrentProcess();

    static native long GetCurrentThread();

    static native long OpenProcessToken(long var0, int var2) throws WindowsException;

    static native long OpenThreadToken(long var0, int var2, boolean var3) throws WindowsException;

    static native long DuplicateTokenEx(long var0, int var2) throws WindowsException;

    static native void SetThreadToken(long var0, long var2) throws WindowsException;

    static native int GetTokenInformation(long var0, int var2, long var3, int var5) throws WindowsException;

    static native void AdjustTokenPrivileges(long var0, long var2, int var4) throws WindowsException;

    static native boolean AccessCheck(long var0, long var2, int var4, int var5, int var6, int var7, int var8) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long LookupPrivilegeValue(String name) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(name);
        try {
            long l = WindowsNativeDispatcher.LookupPrivilegeValue0(buffer.address());
            return l;
        }
        finally {
            buffer.release();
        }
    }

    private static native long LookupPrivilegeValue0(long var0) throws WindowsException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void CreateSymbolicLink(String link, String target, int flags) throws WindowsException {
        NativeBuffer linkBuffer = WindowsNativeDispatcher.asNativeBuffer(link);
        NativeBuffer targetBuffer = WindowsNativeDispatcher.asNativeBuffer(target);
        try {
            WindowsNativeDispatcher.CreateSymbolicLink0(linkBuffer.address(), targetBuffer.address(), flags);
            return;
        }
        catch (WindowsException x) {
            if (x.lastError() != 1314) throw x;
            flags |= 2;
            try {
                WindowsNativeDispatcher.CreateSymbolicLink0(linkBuffer.address(), targetBuffer.address(), flags);
                return;
            }
            catch (WindowsException windowsException) {
                throw x;
            }
        }
        finally {
            targetBuffer.release();
            linkBuffer.release();
        }
    }

    private static native void CreateSymbolicLink0(long var0, long var2, int var4) throws WindowsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void CreateHardLink(String newFile, String existingFile) throws WindowsException {
        NativeBuffer newFileBuffer = WindowsNativeDispatcher.asNativeBuffer(newFile);
        NativeBuffer existingFileBuffer = WindowsNativeDispatcher.asNativeBuffer(existingFile);
        try {
            WindowsNativeDispatcher.CreateHardLink0(newFileBuffer.address(), existingFileBuffer.address());
        }
        finally {
            existingFileBuffer.release();
            newFileBuffer.release();
        }
    }

    private static native void CreateHardLink0(long var0, long var2) throws WindowsException;

    static String GetFullPathName(String path) throws WindowsException {
        NativeBuffer buffer = WindowsNativeDispatcher.asNativeBuffer(path);
        try {
            String string = WindowsNativeDispatcher.GetFullPathName0(buffer.address());
            return string;
        }
        finally {
            buffer.release();
        }
    }

    private static native String GetFullPathName0(long var0) throws WindowsException;

    static native String GetFinalPathNameByHandle(long var0) throws WindowsException;

    static native String FormatMessage(int var0);

    static native void LocalFree(long var0);

    static native long CreateIoCompletionPort(long var0, long var2, long var4) throws WindowsException;

    static CompletionStatus GetQueuedCompletionStatus(long completionPort) throws WindowsException {
        CompletionStatus status = new CompletionStatus();
        WindowsNativeDispatcher.GetQueuedCompletionStatus0(completionPort, status);
        return status;
    }

    private static native void GetQueuedCompletionStatus0(long var0, CompletionStatus var2) throws WindowsException;

    static native void PostQueuedCompletionStatus(long var0, long var2) throws WindowsException;

    static native void ReadDirectoryChangesW(long var0, long var2, int var4, boolean var5, int var6, long var7, long var9) throws WindowsException;

    static native void CancelIo(long var0) throws WindowsException;

    static native int GetOverlappedResult(long var0, long var2) throws WindowsException;

    static NativeBuffer asNativeBuffer(String s) throws WindowsException {
        if (s.length() > 0x3FFFFFFE) {
            throw new WindowsException("String too long to convert to native buffer");
        }
        int stringLengthInBytes = s.length() << 1;
        int sizeInBytes = stringLengthInBytes + 2;
        NativeBuffer buffer = NativeBuffers.getNativeBufferFromCache(sizeInBytes);
        if (buffer == null) {
            buffer = NativeBuffers.allocNativeBuffer(sizeInBytes);
        } else if (buffer.owner() == s) {
            return buffer;
        }
        char[] chars = s.toCharArray();
        unsafe.copyMemory(chars, Unsafe.ARRAY_CHAR_BASE_OFFSET, null, buffer.address(), stringLengthInBytes);
        unsafe.putChar(buffer.address() + (long)stringLengthInBytes, '\u0000');
        buffer.setOwner(s);
        return buffer;
    }

    private static native void initIDs();

    static {
        BootLoader.loadLibrary("net");
        BootLoader.loadLibrary("nio");
        WindowsNativeDispatcher.initIDs();
    }

    static class FirstFile {
        private long handle;
        private String name;
        private int attributes;

        private FirstFile() {
        }

        public long handle() {
            return this.handle;
        }

        public String name() {
            return this.name;
        }

        public int attributes() {
            return this.attributes;
        }
    }

    static class FirstStream {
        private long handle;
        private String name;

        private FirstStream() {
        }

        public long handle() {
            return this.handle;
        }

        public String name() {
            return this.name;
        }
    }

    static class VolumeInformation {
        private String fileSystemName;
        private String volumeName;
        private int volumeSerialNumber;
        private int flags;

        private VolumeInformation() {
        }

        public String fileSystemName() {
            return this.fileSystemName;
        }

        public String volumeName() {
            return this.volumeName;
        }

        public int volumeSerialNumber() {
            return this.volumeSerialNumber;
        }

        public int flags() {
            return this.flags;
        }
    }

    static class DiskFreeSpace {
        private long freeBytesAvailable;
        private long totalNumberOfBytes;
        private long totalNumberOfFreeBytes;
        private long bytesPerSector;

        private DiskFreeSpace() {
        }

        public long freeBytesAvailable() {
            return this.freeBytesAvailable;
        }

        public long totalNumberOfBytes() {
            return this.totalNumberOfBytes;
        }

        public long totalNumberOfFreeBytes() {
            return this.totalNumberOfFreeBytes;
        }

        public long bytesPerSector() {
            return this.bytesPerSector;
        }
    }

    static class AclInformation {
        private int aceCount;

        private AclInformation() {
        }

        public int aceCount() {
            return this.aceCount;
        }
    }

    static class Account {
        private String domain;
        private String name;
        private int use;

        private Account() {
        }

        public String domain() {
            return this.domain;
        }

        public String name() {
            return this.name;
        }

        public int use() {
            return this.use;
        }
    }

    static class CompletionStatus {
        private int error;
        private int bytesTransferred;
        private long completionKey;

        private CompletionStatus() {
        }

        int error() {
            return this.error;
        }

        int bytesTransferred() {
            return this.bytesTransferred;
        }

        long completionKey() {
            return this.completionKey;
        }
    }
}

