/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.net.URI;
import java.net.URISyntaxException;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsPath;

class WindowsUriSupport {
    private static final String IPV6_LITERAL_SUFFIX = ".ipv6-literal.net";

    private WindowsUriSupport() {
    }

    private static URI toUri(String path, boolean isUnc, boolean addSlash) {
        String uriPath;
        String uriHost;
        if (isUnc) {
            int slash = path.indexOf(92, 2);
            uriHost = path.substring(2, slash);
            uriPath = path.substring(slash).replace('\\', '/');
            if (uriHost.endsWith(IPV6_LITERAL_SUFFIX)) {
                uriHost = uriHost.substring(0, uriHost.length() - IPV6_LITERAL_SUFFIX.length()).replace('-', ':').replace('s', '%');
            }
        } else {
            uriHost = "";
            uriPath = "/" + path.replace('\\', '/');
        }
        if (addSlash) {
            uriPath = uriPath + "/";
        }
        try {
            return new URI("file", uriHost, uriPath, null);
        }
        catch (URISyntaxException x) {
            if (!isUnc) {
                throw new AssertionError((Object)x);
            }
            uriPath = "//" + path.replace('\\', '/');
            if (addSlash) {
                uriPath = uriPath + "/";
            }
            try {
                return new URI("file", null, uriPath, null);
            }
            catch (URISyntaxException x2) {
                throw new AssertionError((Object)x2);
            }
        }
    }

    static URI toUri(WindowsPath path) {
        path = path.toAbsolutePath();
        String s = path.toString();
        boolean addSlash = false;
        if (!s.endsWith("\\")) {
            try {
                path.checkRead();
                addSlash = WindowsFileAttributes.get(path, true).isDirectory();
            }
            catch (SecurityException | WindowsException exception) {
                // empty catch block
            }
        }
        return WindowsUriSupport.toUri(s, path.isUnc(), addSlash);
    }

    static WindowsPath fromUri(WindowsFileSystem fs, URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uri.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String path = uri.getPath();
        if (path.isEmpty()) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        String auth = uri.getRawAuthority();
        if (auth != null && !auth.isEmpty()) {
            String host = uri.getHost();
            if (host == null) {
                throw new IllegalArgumentException("URI authority component has undefined host");
            }
            if (uri.getUserInfo() != null) {
                throw new IllegalArgumentException("URI authority component has user-info");
            }
            if (uri.getPort() != -1) {
                throw new IllegalArgumentException("URI authority component has port number");
            }
            if (host.startsWith("[")) {
                host = host.substring(1, host.length() - 1).replace(':', '-').replace('%', 's');
                host = host + IPV6_LITERAL_SUFFIX;
            }
            path = "\\\\" + host + path;
        } else if (path.length() > 2 && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        return WindowsPath.parse(fs, path);
    }
}

