/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.internal.misc.Unsafe;
import sun.nio.fs.AbstractUserDefinedFileAttributeView;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsUserDefinedFileAttributeView
extends AbstractUserDefinedFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final WindowsPath file;
    private final boolean followLinks;

    private String join(String file, String name) {
        if (name == null) {
            throw new NullPointerException("'name' is null");
        }
        return file + ":" + name;
    }

    private String join(WindowsPath file, String name) throws WindowsException {
        return this.join(file.getPathForWin32Calls(), name);
    }

    WindowsUserDefinedFileAttributeView(WindowsPath file, boolean followLinks) {
        this.file = file;
        this.followLinks = followLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> listUsingStreamEnumeration() throws IOException {
        ArrayList<String> list;
        block7: {
            list = new ArrayList<String>();
            try {
                WindowsNativeDispatcher.FirstStream first = WindowsNativeDispatcher.FindFirstStream(this.file.getPathForWin32Calls());
                if (first == null) break block7;
                long handle = first.handle();
                try {
                    String[] segs;
                    String name = first.name();
                    if (!name.equals("::$DATA")) {
                        segs = name.split(":");
                        list.add(segs[1]);
                    }
                    while ((name = WindowsNativeDispatcher.FindNextStream(handle)) != null) {
                        segs = name.split(":");
                        list.add(segs[1]);
                    }
                }
                finally {
                    WindowsNativeDispatcher.FindClose(handle);
                }
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.file);
            }
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<String> list() throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        return this.listUsingStreamEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fc = null;
        try {
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            opts.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fc = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
        }
        try {
            long size = fc.size();
            if (size > Integer.MAX_VALUE) {
                throw new ArithmeticException("Stream too large");
            }
            int n = (int)size;
            return n;
        }
        finally {
            fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String name, ByteBuffer dst) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), true, false);
        }
        FileChannel fc = null;
        try {
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            opts.add(StandardOpenOption.READ);
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            fc = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
        }
        try {
            int n;
            if (fc.size() > (long)dst.remaining()) {
                throw new IOException("Stream too large");
            }
            int total = 0;
            while (dst.hasRemaining() && (n = fc.read(dst)) >= 0) {
                total += n;
            }
            int n2 = total;
            return n2;
        }
        finally {
            fc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(String name, ByteBuffer src) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        long handle = -1L;
        try {
            int flags = 0x2000000;
            if (!this.followLinks) {
                flags |= 0x200000;
            }
            handle = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), Integer.MIN_VALUE, 7, 3, flags);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(this.file);
        }
        try {
            int n;
            HashSet<OpenOption> opts = new HashSet<OpenOption>();
            if (!this.followLinks) {
                opts.add(WindowsChannelFactory.OPEN_REPARSE_POINT);
            }
            opts.add(StandardOpenOption.CREATE);
            opts.add(StandardOpenOption.WRITE);
            opts.add(StandardOpenOption.TRUNCATE_EXISTING);
            FileChannel named = null;
            try {
                named = WindowsChannelFactory.newFileChannel(this.join(this.file, name), null, opts, 0L);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(this.join(this.file.getPathForPermissionCheck(), name));
            }
            try {
                int rem = src.remaining();
                while (src.hasRemaining()) {
                    named.write(src);
                }
                n = rem;
            }
            catch (Throwable throwable) {
                named.close();
                throw throwable;
            }
            named.close();
            return n;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(handle);
        }
    }

    @Override
    public void delete(String name) throws IOException {
        if (System.getSecurityManager() != null) {
            this.checkAccess(this.file.getPathForPermissionCheck(), false, true);
        }
        String path = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        String toDelete = this.join(path, name);
        try {
            WindowsNativeDispatcher.DeleteFile(toDelete);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(toDelete);
        }
    }
}

