/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

class WindowsUserPrincipals {
    private WindowsUserPrincipals() {
    }

    static UserPrincipal fromSid(long sidAddress) throws IOException {
        int sidType;
        String name;
        String sidString;
        try {
            sidString = WindowsNativeDispatcher.ConvertSidToStringSid(sidAddress);
            if (sidString == null) {
                throw new AssertionError();
            }
        }
        catch (WindowsException x) {
            throw new IOException("Unable to convert SID to String: " + x.errorString());
        }
        WindowsNativeDispatcher.Account account = null;
        try {
            account = WindowsNativeDispatcher.LookupAccountSid(sidAddress);
            name = account.domain() + "\\" + account.name();
        }
        catch (WindowsException x) {
            name = sidString;
        }
        int n = sidType = account == null ? 8 : account.use();
        if (sidType == 2 || sidType == 5 || sidType == 4) {
            return new Group(sidString, sidType, name);
        }
        return new User(sidString, sidType, name);
    }

    static UserPrincipal lookup(String name) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("lookupUserInformation"));
        }
        int size = 0;
        try {
            size = WindowsNativeDispatcher.LookupAccountName(name, 0L, 0);
        }
        catch (WindowsException x) {
            if (x.lastError() == 1332) {
                throw new UserPrincipalNotFoundException(name);
            }
            throw new IOException(name + ": " + x.errorString());
        }
        assert (size > 0);
        NativeBuffer sidBuffer = NativeBuffers.getNativeBuffer(size);
        try {
            int newSize = WindowsNativeDispatcher.LookupAccountName(name, sidBuffer.address(), size);
            if (newSize != size) {
                throw new AssertionError((Object)"SID change during lookup");
            }
            UserPrincipal userPrincipal = WindowsUserPrincipals.fromSid(sidBuffer.address());
            return userPrincipal;
        }
        catch (WindowsException x) {
            throw new IOException(name + ": " + x.errorString());
        }
        finally {
            sidBuffer.release();
        }
    }

    static class Group
    extends User
    implements GroupPrincipal {
        Group(String sidString, int sidType, String accountName) {
            super(sidString, sidType, accountName);
        }
    }

    static class User
    implements UserPrincipal {
        private final String sidString;
        private final int sidType;
        private final String accountName;

        User(String sidString, int sidType, String accountName) {
            this.sidString = sidString;
            this.sidType = sidType;
            this.accountName = accountName;
        }

        String sidString() {
            return this.sidString;
        }

        @Override
        public String getName() {
            return this.accountName;
        }

        @Override
        public String toString() {
            return this.accountName + " (" + (switch (this.sidType) {
                case 1 -> "User";
                case 2 -> "Group";
                case 3 -> "Domain";
                case 4 -> "Alias";
                case 5 -> "Well-known group";
                case 6 -> "Deleted";
                case 7 -> "Invalid";
                case 9 -> "Computer";
                default -> "Unknown";
            }) + ")";
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            User other = (User)obj;
            return this.sidString.equals(other.sidString);
        }

        @Override
        public int hashCode() {
            return this.sidString.hashCode();
        }
    }
}

