/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

public final class AnnotatedTypeFactory {
    static final TypeAnnotation[] EMPTY_TYPE_ANNOTATION_ARRAY = new TypeAnnotation[0];
    static final AnnotatedType EMPTY_ANNOTATED_TYPE = new AnnotatedTypeBaseImpl(null, TypeAnnotation.LocationInfo.BASE_LOCATION, EMPTY_TYPE_ANNOTATION_ARRAY, EMPTY_TYPE_ANNOTATION_ARRAY, null);
    static final AnnotatedType[] EMPTY_ANNOTATED_TYPE_ARRAY = new AnnotatedType[0];

    public static AnnotatedType buildAnnotatedType(Type type, TypeAnnotation.LocationInfo currentLoc, TypeAnnotation[] actualTypeAnnos, TypeAnnotation[] allOnSameTarget, AnnotatedElement decl) {
        if (type == null) {
            return EMPTY_ANNOTATED_TYPE;
        }
        if (AnnotatedTypeFactory.isArray(type)) {
            return new AnnotatedArrayTypeImpl(type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof Class) {
            return new AnnotatedTypeBaseImpl(type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof ParameterizedType) {
            return new AnnotatedParameterizedTypeImpl((ParameterizedType)type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        if (type instanceof WildcardType) {
            return new AnnotatedWildcardTypeImpl((WildcardType)type, currentLoc, actualTypeAnnos, allOnSameTarget, decl);
        }
        throw new AssertionError((Object)("Unknown instance of Type: " + type + "\nThis should not happen."));
    }

    public static TypeAnnotation.LocationInfo nestingForType(Type type, TypeAnnotation.LocationInfo addTo) {
        if (AnnotatedTypeFactory.isArray(type)) {
            return addTo;
        }
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (clz.getEnclosingClass() == null) {
                return addTo;
            }
            if (Modifier.isStatic(clz.getModifiers())) {
                return addTo;
            }
            return AnnotatedTypeFactory.nestingForType(clz.getEnclosingClass(), addTo.pushInner());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            if (t.getOwnerType() == null) {
                return addTo;
            }
            if (t.getRawType() instanceof Class && Modifier.isStatic(((Class)t.getRawType()).getModifiers())) {
                return addTo;
            }
            return AnnotatedTypeFactory.nestingForType(t.getOwnerType(), addTo.pushInner());
        }
        return addTo;
    }

    private static boolean isArray(Type t) {
        Class c;
        return t instanceof Class ? (c = (Class)t).isArray() : t instanceof GenericArrayType;
    }

    private static final class AnnotatedArrayTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedArrayType {
        AnnotatedArrayTypeImpl(Type type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            Type t = this.getComponentType();
            return AnnotatedTypeFactory.buildAnnotatedType(t, AnnotatedTypeFactory.nestingForType(t, this.getLocation().pushArray()), this.getTypeAnnotations(), this.getTypeAnnotations(), this.getDecl());
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }

        private Type getComponentType() {
            Type t = this.getType();
            if (t instanceof Class) {
                Class c = (Class)t;
                return c.getComponentType();
            }
            return ((GenericArrayType)t).getGenericComponentType();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            AnnotatedType componentType = this;
            while (componentType instanceof AnnotatedArrayType) {
                AnnotatedArrayType annotatedArrayType = componentType;
                sb.append(this.annotationsToString(annotatedArrayType.getAnnotations(), true) + "[]");
                componentType = annotatedArrayType.getAnnotatedGenericComponentType();
            }
            sb.insert(0, ((Object)componentType).toString());
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AnnotatedArrayType) {
                AnnotatedArrayType that = (AnnotatedArrayType)o;
                return this.equalsTypeAndAnnotations(that) && Objects.equals(this.getAnnotatedGenericComponentType(), that.getAnnotatedGenericComponentType());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseHashCode() ^ this.getAnnotatedGenericComponentType().hashCode();
        }
    }

    private static class AnnotatedTypeBaseImpl
    implements AnnotatedType {
        private final Type type;
        private final AnnotatedElement decl;
        private final TypeAnnotation.LocationInfo location;
        private final TypeAnnotation[] allOnSameTargetTypeAnnotations;
        private final Map<Class<? extends Annotation>, Annotation> annotations;

        AnnotatedTypeBaseImpl(Type type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            this.type = type;
            this.decl = decl;
            this.location = location;
            this.allOnSameTargetTypeAnnotations = allOnSameTargetTypeAnnotations;
            this.annotations = TypeAnnotationParser.mapTypeAnnotations(location.filter(actualTypeAnnotations));
        }

        @Override
        public final Annotation[] getAnnotations() {
            return this.getDeclaredAnnotations();
        }

        @Override
        public final <T extends Annotation> T getAnnotation(Class<T> annotation) {
            return this.getDeclaredAnnotation(annotation);
        }

        @Override
        public final <T extends Annotation> T[] getAnnotationsByType(Class<T> annotation) {
            return this.getDeclaredAnnotationsByType(annotation);
        }

        @Override
        public final Annotation[] getDeclaredAnnotations() {
            return this.annotations.values().toArray(new Annotation[0]);
        }

        @Override
        public final <T extends Annotation> T getDeclaredAnnotation(Class<T> annotation) {
            return (T)this.annotations.get(annotation);
        }

        @Override
        public final <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotation) {
            return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotations, annotation);
        }

        @Override
        public final Type getType() {
            return this.type;
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            if (!(this.type instanceof Class)) {
                throw new IllegalStateException("Can't compute owner");
            }
            Class nested = (Class)this.type;
            Class<?> owner = nested.getDeclaringClass();
            if (owner == null) {
                return null;
            }
            if (nested.isPrimitive() || nested == Void.TYPE) {
                return null;
            }
            TypeAnnotation.LocationInfo outerLoc = this.getLocation().popLocation((byte)1);
            if (outerLoc == null) {
                return AnnotatedTypeFactory.buildAnnotatedType(owner, TypeAnnotation.LocationInfo.BASE_LOCATION, EMPTY_TYPE_ANNOTATION_ARRAY, EMPTY_TYPE_ANNOTATION_ARRAY, this.getDecl());
            }
            TypeAnnotation[] all = this.getTypeAnnotations();
            ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(all.length);
            for (TypeAnnotation t : all) {
                if (!t.getLocationInfo().isSameLocationInfo(outerLoc)) continue;
                l.add(t);
            }
            return AnnotatedTypeFactory.buildAnnotatedType(owner, outerLoc, l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), all, this.getDecl());
        }

        public String toString() {
            return this.annotationsToString(this.getAnnotations(), false) + (this.type instanceof Class ? this.type.getTypeName() : this.type.toString());
        }

        protected String annotationsToString(Annotation[] annotations, boolean leadingSpace) {
            if (annotations != null && annotations.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(Stream.of(annotations).map(Annotation::toString).collect(Collectors.joining(" ")));
                if (leadingSpace) {
                    sb.insert(0, " ");
                } else {
                    sb.append(" ");
                }
                return sb.toString();
            }
            return "";
        }

        protected boolean equalsTypeAndAnnotations(AnnotatedType that) {
            return this.getType().equals(that.getType()) && Arrays.equals(this.getAnnotations(), that.getAnnotations()) && Objects.equals(this.getAnnotatedOwnerType(), that.getAnnotatedOwnerType());
        }

        int baseHashCode() {
            return this.type.hashCode() ^ Objects.hash(this.getAnnotations()) ^ Objects.hash(this.getAnnotatedOwnerType());
        }

        public boolean equals(Object o) {
            if (!(!(o instanceof AnnotatedType) || o instanceof AnnotatedArrayType || o instanceof AnnotatedTypeVariable || o instanceof AnnotatedParameterizedType || o instanceof AnnotatedWildcardType)) {
                AnnotatedType that = (AnnotatedType)o;
                return this.equalsTypeAndAnnotations(that);
            }
            return false;
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        final TypeAnnotation.LocationInfo getLocation() {
            return this.location;
        }

        final TypeAnnotation[] getTypeAnnotations() {
            return this.allOnSameTargetTypeAnnotations;
        }

        final AnnotatedElement getDecl() {
            return this.decl;
        }
    }

    private static final class AnnotatedTypeVariableImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedTypeVariable {
        AnnotatedTypeVariableImpl(TypeVariable<?> type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return this.getTypeVariable().getAnnotatedBounds();
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }

        private TypeVariable<?> getTypeVariable() {
            return (TypeVariable)this.getType();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AnnotatedTypeVariable) {
                AnnotatedTypeVariable that = (AnnotatedTypeVariable)o;
                return this.equalsTypeAndAnnotations(that);
            }
            return false;
        }
    }

    private static final class AnnotatedParameterizedTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedParameterizedType {
        AnnotatedParameterizedTypeImpl(ParameterizedType type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            Type[] arguments = this.getParameterizedType().getActualTypeArguments();
            Object[] res = new AnnotatedType[arguments.length];
            Arrays.fill(res, EMPTY_ANNOTATED_TYPE);
            int initialCapacity = this.getTypeAnnotations().length;
            for (int i = 0; i < res.length; ++i) {
                ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(initialCapacity);
                TypeAnnotation.LocationInfo newLoc = AnnotatedTypeFactory.nestingForType(arguments[i], this.getLocation().pushTypeArg((byte)i));
                for (TypeAnnotation t : this.getTypeAnnotations()) {
                    if (!t.getLocationInfo().isSameLocationInfo(newLoc)) continue;
                    l.add(t);
                }
                res[i] = AnnotatedTypeFactory.buildAnnotatedType(arguments[i], newLoc, l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), this.getTypeAnnotations(), this.getDecl());
            }
            return res;
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            Type owner = this.getParameterizedType().getOwnerType();
            if (owner == null) {
                return null;
            }
            TypeAnnotation.LocationInfo outerLoc = this.getLocation().popLocation((byte)1);
            if (outerLoc == null) {
                return AnnotatedTypeFactory.buildAnnotatedType(owner, TypeAnnotation.LocationInfo.BASE_LOCATION, EMPTY_TYPE_ANNOTATION_ARRAY, EMPTY_TYPE_ANNOTATION_ARRAY, this.getDecl());
            }
            TypeAnnotation[] all = this.getTypeAnnotations();
            ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(all.length);
            for (TypeAnnotation t : all) {
                if (!t.getLocationInfo().isSameLocationInfo(outerLoc)) continue;
                l.add(t);
            }
            return AnnotatedTypeFactory.buildAnnotatedType(owner, outerLoc, l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), all, this.getDecl());
        }

        private ParameterizedType getParameterizedType() {
            return (ParameterizedType)this.getType();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.annotationsToString(this.getAnnotations(), false));
            Type t = this.getParameterizedType().getRawType();
            sb.append(t.getTypeName());
            AnnotatedType[] typeArgs = this.getAnnotatedActualTypeArguments();
            if (typeArgs.length > 0) {
                sb.append(Stream.of(typeArgs).map(Object::toString).collect(Collectors.joining(", ", "<", ">")));
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType that = (AnnotatedParameterizedType)o;
                return this.equalsTypeAndAnnotations(that) && Arrays.equals(this.getAnnotatedActualTypeArguments(), that.getAnnotatedActualTypeArguments());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseHashCode() ^ Objects.hash(this.getAnnotatedActualTypeArguments());
        }
    }

    private static final class AnnotatedWildcardTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedWildcardType {
        private final boolean hasUpperBounds;

        AnnotatedWildcardTypeImpl(WildcardType type, TypeAnnotation.LocationInfo location, TypeAnnotation[] actualTypeAnnotations, TypeAnnotation[] allOnSameTargetTypeAnnotations, AnnotatedElement decl) {
            super(type, location, actualTypeAnnotations, allOnSameTargetTypeAnnotations, decl);
            this.hasUpperBounds = type.getLowerBounds().length == 0;
        }

        @Override
        public AnnotatedType[] getAnnotatedUpperBounds() {
            if (!this.hasUpperBounds()) {
                return new AnnotatedType[]{AnnotatedTypeFactory.buildAnnotatedType(Object.class, TypeAnnotation.LocationInfo.BASE_LOCATION, EMPTY_TYPE_ANNOTATION_ARRAY, EMPTY_TYPE_ANNOTATION_ARRAY, null)};
            }
            return this.getAnnotatedBounds(this.getWildcardType().getUpperBounds());
        }

        @Override
        public AnnotatedType[] getAnnotatedLowerBounds() {
            if (this.hasUpperBounds) {
                return new AnnotatedType[0];
            }
            return this.getAnnotatedBounds(this.getWildcardType().getLowerBounds());
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            return null;
        }

        private AnnotatedType[] getAnnotatedBounds(Type[] bounds) {
            Object[] res = new AnnotatedType[bounds.length];
            Arrays.fill(res, EMPTY_ANNOTATED_TYPE);
            int initialCapacity = this.getTypeAnnotations().length;
            for (int i = 0; i < res.length; ++i) {
                TypeAnnotation.LocationInfo newLoc = AnnotatedTypeFactory.nestingForType(bounds[i], this.getLocation().pushWildcard());
                ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(initialCapacity);
                for (TypeAnnotation t : this.getTypeAnnotations()) {
                    if (!t.getLocationInfo().isSameLocationInfo(newLoc)) continue;
                    l.add(t);
                }
                res[i] = AnnotatedTypeFactory.buildAnnotatedType(bounds[i], newLoc, l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), this.getTypeAnnotations(), this.getDecl());
            }
            return res;
        }

        private WildcardType getWildcardType() {
            return (WildcardType)this.getType();
        }

        private boolean hasUpperBounds() {
            return this.hasUpperBounds;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.annotationsToString(this.getAnnotations(), false));
            sb.append("?");
            AnnotatedType[] bounds = this.getAnnotatedLowerBounds();
            if (bounds.length > 0) {
                sb.append(" super ");
            } else {
                bounds = this.getAnnotatedUpperBounds();
                if (bounds.length > 0) {
                    AnnotatedType bound;
                    if (bounds.length == 1 && (bound = bounds[0]).getType().equals(Object.class) && bound.getAnnotations().length == 0) {
                        return sb.toString();
                    }
                    sb.append(" extends ");
                }
            }
            sb.append(Stream.of(bounds).map(Object::toString).collect(Collectors.joining(" & ")));
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AnnotatedWildcardType) {
                AnnotatedWildcardType that = (AnnotatedWildcardType)o;
                return this.equalsTypeAndAnnotations(that) && Arrays.equals(this.getAnnotatedLowerBounds(), that.getAnnotatedLowerBounds()) && Arrays.equals(this.getAnnotatedUpperBounds(), that.getAnnotatedUpperBounds());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseHashCode() ^ Objects.hash(this.getAnnotatedLowerBounds()) ^ Objects.hash(this.getAnnotatedUpperBounds());
        }
    }
}

