/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.StringJoiner;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;

public class WildcardTypeImpl
extends LazyReflectiveObjectGenerator
implements WildcardType {
    private volatile Object[] upperBounds;
    private volatile Object[] lowerBounds;

    private WildcardTypeImpl(FieldTypeSignature[] ubs, FieldTypeSignature[] lbs, GenericsFactory f) {
        super(f);
        this.upperBounds = ubs;
        this.lowerBounds = lbs;
    }

    public static WildcardTypeImpl make(FieldTypeSignature[] ubs, FieldTypeSignature[] lbs, GenericsFactory f) {
        return new WildcardTypeImpl(ubs, lbs, f);
    }

    @Override
    public Type[] getUpperBounds() {
        Object[] value = this.upperBounds;
        if (value instanceof FieldTypeSignature[]) {
            this.upperBounds = value = this.reifyBounds((FieldTypeSignature[])value);
        }
        return (Type[])value.clone();
    }

    @Override
    public Type[] getLowerBounds() {
        Object[] value = this.lowerBounds;
        if (value instanceof FieldTypeSignature[]) {
            this.lowerBounds = value = this.reifyBounds((FieldTypeSignature[])value);
        }
        return (Type[])value.clone();
    }

    public String toString() {
        Type[] lowerBounds;
        Type[] bounds = lowerBounds = this.getLowerBounds();
        StringBuilder sb = new StringBuilder();
        if (lowerBounds.length > 0) {
            sb.append("? super ");
        } else {
            Type[] upperBounds = this.getUpperBounds();
            if (upperBounds.length > 0 && !upperBounds[0].equals(Object.class)) {
                bounds = upperBounds;
                sb.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (bounds.length > 0);
        StringJoiner sj = new StringJoiner(" & ");
        for (Type bound : bounds) {
            sj.add(bound.getTypeName());
        }
        sb.append(sj.toString());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardType) {
            WildcardType that = (WildcardType)o;
            return Arrays.equals(this.getLowerBounds(), that.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), that.getUpperBounds());
        }
        return false;
    }

    public int hashCode() {
        Object[] lowerBounds = this.getLowerBounds();
        Object[] upperBounds = this.getUpperBounds();
        return Arrays.hashCode(lowerBounds) ^ Arrays.hashCode(upperBounds);
    }
}

