/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.tree.MethodTypeSignature;
import sun.reflect.generics.tree.TypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class ConstructorRepository
extends GenericDeclRepository<MethodTypeSignature> {
    private volatile Type[] parameterTypes;
    private volatile Type[] exceptionTypes;

    protected ConstructorRepository(String rawSig, GenericsFactory f) {
        super(rawSig, f);
    }

    @Override
    protected MethodTypeSignature parse(String s) {
        return SignatureParser.make().parseMethodSig(s);
    }

    public static ConstructorRepository make(String rawSig, GenericsFactory f) {
        return new ConstructorRepository(rawSig, f);
    }

    public Type[] getParameterTypes() {
        Type[] value = this.parameterTypes;
        if (value == null) {
            this.parameterTypes = value = this.computeParameterTypes();
        }
        return (Type[])value.clone();
    }

    public Type[] getExceptionTypes() {
        Type[] value = this.exceptionTypes;
        if (value == null) {
            this.exceptionTypes = value = this.computeExceptionTypes();
        }
        return (Type[])value.clone();
    }

    private Type[] computeParameterTypes() {
        TypeSignature[] pts = ((MethodTypeSignature)this.getTree()).getParameterTypes();
        int length = pts.length;
        Type[] parameterTypes = new Type[length];
        for (int i = 0; i < length; ++i) {
            Reifier r = this.getReifier();
            pts[i].accept(r);
            parameterTypes[i] = r.getResult();
        }
        return parameterTypes;
    }

    private Type[] computeExceptionTypes() {
        FieldTypeSignature[] ets = ((MethodTypeSignature)this.getTree()).getExceptionTypes();
        int length = ets.length;
        Type[] exceptionTypes = new Type[length];
        for (int i = 0; i < length; ++i) {
            Reifier r = this.getReifier();
            ets[i].accept(r);
            exceptionTypes[i] = r.getResult();
        }
        return exceptionTypes;
    }
}

