/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.SecureRandom;

public final class JCAUtil {
    private static final int ARRAY_SIZE = 4096;
    private static volatile SecureRandom def = null;

    private JCAUtil() {
    }

    public static int getTempArraySize(int totalSize) {
        return Math.min(4096, totalSize);
    }

    public static SecureRandom getSecureRandom() {
        return CachedSecureRandomHolder.instance;
    }

    static void clearDefSecureRandom() {
        def = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecureRandom getDefSecureRandom() {
        SecureRandom result = def;
        if (result != null) return result;
        Class<JCAUtil> clazz = JCAUtil.class;
        synchronized (JCAUtil.class) {
            result = def;
            if (result != null) return result;
            def = result = new SecureRandom();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static class CachedSecureRandomHolder {
        public static SecureRandom instance = new SecureRandom();

        private CachedSecureRandomHolder() {
        }
    }
}

