/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.sun.crypto.provider.SunJCE;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import sun.security.provider.Sun;
import sun.security.rsa.SunRsaSign;
import sun.security.ssl.SunJSSE;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

final class ProviderConfig {
    private static final Debug debug = Debug.getInstance("jca", "ProviderConfig");
    private static final String P11_SOL_NAME = "SunPKCS11";
    private static final String P11_SOL_ARG = "${java.home}/conf/security/sunpkcs11-solaris.cfg";
    private static final int MAX_LOAD_TRIES = 30;
    private final String provName;
    private final String argument;
    private int tries;
    private volatile Provider provider;
    private boolean isLoading;

    ProviderConfig(String provName, String argument) {
        if (provName.endsWith(P11_SOL_NAME) && argument.equals(P11_SOL_ARG)) {
            this.checkSunPKCS11Solaris();
        }
        this.provName = provName;
        this.argument = ProviderConfig.expand(argument);
    }

    ProviderConfig(String provName) {
        this(provName, "");
    }

    ProviderConfig(Provider provider) {
        this.provName = provider.getName();
        this.argument = "";
        this.provider = provider;
    }

    private void checkSunPKCS11Solaris() {
        Boolean o = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = new File("/usr/lib/libpkcs11.so");
                if (!file.exists()) {
                    return Boolean.FALSE;
                }
                if ("false".equalsIgnoreCase(System.getProperty("sun.security.pkcs11.enable-solaris"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        if (o == Boolean.FALSE) {
            this.tries = 30;
        }
    }

    private boolean hasArgument() {
        return !this.argument.isEmpty();
    }

    private boolean shouldLoad() {
        return this.tries < 30;
    }

    private void disableLoad() {
        this.tries = 30;
    }

    boolean isLoaded() {
        return this.provider != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProviderConfig)) {
            return false;
        }
        ProviderConfig other = (ProviderConfig)obj;
        return this.provName.equals(other.provName) && this.argument.equals(other.argument);
    }

    public int hashCode() {
        return this.provName.hashCode() + this.argument.hashCode();
    }

    public String toString() {
        if (this.hasArgument()) {
            return this.provName + "('" + this.argument + "')";
        }
        return this.provName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Provider getProvider() {
        Provider p = this.provider;
        if (p != null) {
            return p;
        }
        ProviderConfig providerConfig = this;
        synchronized (providerConfig) {
            p = this.provider;
            if (p != null) {
                return p;
            }
            if (!this.shouldLoad()) {
                return null;
            }
            if (this.provName.equals("SUN") || this.provName.equals("sun.security.provider.Sun")) {
                p = new Sun();
            } else if (this.provName.equals("SunRsaSign") || this.provName.equals("sun.security.rsa.SunRsaSign")) {
                p = new SunRsaSign();
            } else if (this.provName.equals("SunJCE") || this.provName.equals("com.sun.crypto.provider.SunJCE")) {
                p = new SunJCE();
            } else if (this.provName.equals("SunJSSE")) {
                p = new SunJSSE();
            } else if (this.provName.equals("Apple") || this.provName.equals("apple.security.AppleProvider")) {
                Provider tmp;
                p = tmp = AccessController.doPrivileged(new PrivilegedAction<Provider>(){

                    @Override
                    public Provider run() {
                        try {
                            Class<?> c = Class.forName("apple.security.AppleProvider");
                            if (Provider.class.isAssignableFrom(c)) {
                                Object tmp = c.newInstance();
                                return (Provider)tmp;
                            }
                            return null;
                        }
                        catch (Exception ex) {
                            if (debug != null) {
                                debug.println("Error loading provider Apple");
                                ex.printStackTrace();
                            }
                            return null;
                        }
                    }
                });
            } else {
                if (this.isLoading) {
                    if (debug != null) {
                        debug.println("Recursion loading provider: " + this);
                        new Exception("Call trace").printStackTrace();
                    }
                    return null;
                }
                try {
                    this.isLoading = true;
                    ++this.tries;
                    p = this.doLoadProvider();
                }
                finally {
                    this.isLoading = false;
                }
            }
            this.provider = p;
        }
        return p;
    }

    private Provider doLoadProvider() {
        return AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                if (debug != null) {
                    debug.println("Loading provider " + ProviderConfig.this);
                }
                try {
                    Provider p = ProviderLoader.INSTANCE.load(ProviderConfig.this.provName);
                    if (p != null) {
                        if (ProviderConfig.this.hasArgument()) {
                            p = p.configure(ProviderConfig.this.argument);
                        }
                        if (debug != null) {
                            debug.println("Loaded provider " + p.getName());
                        }
                    } else {
                        if (debug != null) {
                            debug.println("Error loading provider " + ProviderConfig.this);
                        }
                        ProviderConfig.this.disableLoad();
                    }
                    return p;
                }
                catch (Exception e) {
                    if (e instanceof ProviderException) {
                        throw e;
                    }
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        e.printStackTrace();
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
                catch (ExceptionInInitializerError err) {
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        err.printStackTrace();
                    }
                    ProviderConfig.this.disableLoad();
                    return null;
                }
            }
        });
    }

    private static String expand(final String value) {
        if (!value.contains("${")) {
            return value;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return PropertyExpander.expand(value);
                }
                catch (GeneralSecurityException e) {
                    throw new ProviderException(e);
                }
            }
        });
    }

    private static final class ProviderLoader {
        static final ProviderLoader INSTANCE = new ProviderLoader();
        private final ServiceLoader<Provider> services = ServiceLoader.load(Provider.class, ClassLoader.getSystemClassLoader());

        private ProviderLoader() {
        }

        public Provider load(String pn) {
            if (debug != null) {
                debug.println("Attempt to load " + pn + " using SL");
            }
            Iterator<Provider> iter = this.services.iterator();
            while (iter.hasNext()) {
                try {
                    Provider p = iter.next();
                    String pName = p.getName();
                    if (debug != null) {
                        debug.println("Found SL Provider named " + pName);
                    }
                    if (!pName.equals(pn)) continue;
                    return p;
                }
                catch (SecurityException | InvalidParameterException | ServiceConfigurationError ex) {
                    if (debug == null) continue;
                    debug.println("Encountered " + ex + " while iterating through SL, ignore and move on");
                    ex.printStackTrace();
                }
            }
            try {
                return this.legacyLoad(pn);
            }
            catch (ProviderException pe) {
                throw pe;
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.println("Encountered " + ex + " during legacy load of " + pn);
                    ex.printStackTrace();
                }
                return null;
            }
        }

        private Provider legacyLoad(String classname) {
            if (debug != null) {
                debug.println("Loading legacy provider: " + classname);
            }
            try {
                final Class<?> provClass = ClassLoader.getSystemClassLoader().loadClass(classname);
                if (!Provider.class.isAssignableFrom(provClass)) {
                    if (debug != null) {
                        debug.println(classname + " is not a provider");
                    }
                    return null;
                }
                Provider p = AccessController.doPrivileged(new PrivilegedExceptionAction<Provider>(){

                    @Override
                    public Provider run() throws Exception {
                        return (Provider)provClass.newInstance();
                    }
                });
                return p;
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e;
                if (debug != null) {
                    debug.println("Error loading legacy provider " + classname);
                    t.printStackTrace();
                }
                if (t instanceof ProviderException) {
                    throw (ProviderException)t;
                }
                return null;
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError err) {
                if (debug != null) {
                    debug.println("Error loading legacy provider " + classname);
                    err.printStackTrace();
                }
                return null;
            }
        }
    }
}

