/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import sun.security.jca.ProviderConfig;
import sun.security.jca.ServiceId;
import sun.security.util.Debug;

public final class ProviderList {
    static final Debug debug = Debug.getInstance("jca", "ProviderList");
    private static final ProviderConfig[] PC0 = new ProviderConfig[0];
    private static final Provider[] P0 = new Provider[0];
    static final ProviderList EMPTY = new ProviderList(PC0, true);
    private static PreferredList preferredPropList = null;
    private static final Provider EMPTY_PROVIDER = new Provider("##Empty##", "1.0", "initialization in progress"){
        private static final long serialVersionUID = 1151354171352296389L;

        @Override
        public Provider.Service getService(String type, String algorithm) {
            return null;
        }
    };
    private final ProviderConfig[] configs;
    private volatile boolean allLoaded;
    private final List<Provider> userList = new AbstractList<Provider>(){

        @Override
        public int size() {
            return ProviderList.this.configs.length;
        }

        @Override
        public Provider get(int index) {
            return ProviderList.this.getProvider(index);
        }
    };
    private static final String[] SHA2Group = new String[]{"SHA-224", "SHA-256", "SHA-384", "SHA-512", "SHA-512/224", "SHA-512/256"};
    private static final String[] HmacSHA2Group = new String[]{"HmacSHA224", "HmacSHA256", "HmacSHA384", "HmacSHA512"};
    private static final String[] SHA2RSAGroup = new String[]{"SHA224withRSA", "SHA256withRSA", "SHA384withRSA", "SHA512withRSA"};
    private static final String[] SHA2DSAGroup = new String[]{"SHA224withDSA", "SHA256withDSA", "SHA384withDSA", "SHA512withDSA"};
    private static final String[] SHA2ECDSAGroup = new String[]{"SHA224withECDSA", "SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA"};
    private static final String[] SHA3Group = new String[]{"SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512"};
    private static final String[] HmacSHA3Group = new String[]{"HmacSHA3-224", "HmacSHA3-256", "HmacSHA3-384", "HmacSHA3-512"};

    static ProviderList fromSecurityProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<ProviderList>(){

            @Override
            public ProviderList run() {
                return new ProviderList();
            }
        });
    }

    public static ProviderList add(ProviderList providerList, Provider p) {
        return ProviderList.insertAt(providerList, p, -1);
    }

    public static ProviderList insertAt(ProviderList providerList, Provider p, int position) {
        if (providerList.getProvider(p.getName()) != null) {
            return providerList;
        }
        ArrayList<ProviderConfig> list = new ArrayList<ProviderConfig>(Arrays.asList(providerList.configs));
        int n = list.size();
        if (position < 0 || position > n) {
            position = n;
        }
        list.add(position, new ProviderConfig(p));
        return new ProviderList(list.toArray(PC0), true);
    }

    public static ProviderList remove(ProviderList providerList, String name) {
        if (providerList.getProvider(name) == null) {
            return providerList;
        }
        ProviderConfig[] configs = new ProviderConfig[providerList.size() - 1];
        int j = 0;
        for (ProviderConfig config : providerList.configs) {
            if (config.getProvider().getName().equals(name)) continue;
            configs[j++] = config;
        }
        return new ProviderList(configs, true);
    }

    public static ProviderList newList(Provider ... providers) {
        ProviderConfig[] configs = new ProviderConfig[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            configs[i] = new ProviderConfig(providers[i]);
        }
        return new ProviderList(configs, true);
    }

    private ProviderList(ProviderConfig[] configs, boolean allLoaded) {
        this.configs = configs;
        this.allLoaded = allLoaded;
    }

    private ProviderList() {
        String entry;
        ArrayList<ProviderConfig> configList = new ArrayList<ProviderConfig>();
        int i = 1;
        while ((entry = Security.getProperty("security.provider." + i)) != null) {
            ProviderConfig config;
            if ((entry = entry.trim()).isEmpty()) {
                System.err.println("invalid entry for security.provider." + i);
                break;
            }
            int k = entry.indexOf(32);
            if (k == -1) {
                config = new ProviderConfig(entry);
            } else {
                String provName = entry.substring(0, k);
                String argument = entry.substring(k + 1).trim();
                config = new ProviderConfig(provName, argument);
            }
            if (!configList.contains(config)) {
                configList.add(config);
            }
            ++i;
        }
        this.configs = configList.toArray(PC0);
        entry = Security.getProperty("jdk.security.provider.preferred");
        if (entry != null && !(entry = entry.trim()).isEmpty()) {
            String[] entries = entry.split(",");
            if (preferredPropList == null) {
                preferredPropList = new PreferredList();
            }
            for (String e : entries) {
                i = e.indexOf(58);
                if (i < 0) {
                    if (debug == null) continue;
                    debug.println("invalid preferred entry skipped.  Missing colon delimiter \"" + e + "\"");
                    continue;
                }
                preferredPropList.add(new PreferredEntry(e.substring(0, i).trim(), e.substring(i + 1).trim()));
            }
        }
        if (debug != null) {
            debug.println("provider configuration: " + configList);
            debug.println("config configuration: " + preferredPropList);
        }
    }

    ProviderList getJarList(String[] jarProvNames) {
        ArrayList<ProviderConfig> newConfigs = new ArrayList<ProviderConfig>();
        for (String provName : jarProvNames) {
            ProviderConfig newConfig = new ProviderConfig(provName);
            for (ProviderConfig config : this.configs) {
                if (!config.equals(newConfig)) continue;
                newConfig = config;
                break;
            }
            newConfigs.add(newConfig);
        }
        ProviderConfig[] configArray = newConfigs.toArray(PC0);
        return new ProviderList(configArray, false);
    }

    public int size() {
        return this.configs.length;
    }

    Provider getProvider(int index) {
        Provider p = this.configs[index].getProvider();
        return p != null ? p : EMPTY_PROVIDER;
    }

    public List<Provider> providers() {
        return this.userList;
    }

    private ProviderConfig getProviderConfig(String name) {
        int index = this.getIndex(name);
        return index != -1 ? this.configs[index] : null;
    }

    public Provider getProvider(String name) {
        ProviderConfig config = this.getProviderConfig(name);
        return config == null ? null : config.getProvider();
    }

    public int getIndex(String name) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider p = this.getProvider(i);
            if (!p.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private int loadAll() {
        if (this.allLoaded) {
            return this.configs.length;
        }
        if (debug != null) {
            debug.println("Loading all providers");
            new Exception("Debug Info. Call trace:").printStackTrace();
        }
        int n = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            Provider p = this.configs[i].getProvider();
            if (p == null) continue;
            ++n;
        }
        if (n == this.configs.length) {
            this.allLoaded = true;
        }
        return n;
    }

    ProviderList removeInvalid() {
        int n = this.loadAll();
        if (n == this.configs.length) {
            return this;
        }
        ProviderConfig[] newConfigs = new ProviderConfig[n];
        int j = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            ProviderConfig config = this.configs[i];
            if (!config.isLoaded()) continue;
            newConfigs[j++] = config;
        }
        return new ProviderList(newConfigs, true);
    }

    public Provider[] toArray() {
        return this.providers().toArray(P0);
    }

    public String toString() {
        return Arrays.asList(this.configs).toString();
    }

    public Provider.Service getService(String type, String name) {
        Provider.Service s;
        Provider p;
        int i;
        ArrayList<PreferredEntry> pList = null;
        if (preferredPropList != null && (pList = preferredPropList.getAll(type, name)) != null) {
            for (i = 0; i < pList.size(); ++i) {
                p = this.getProvider(pList.get((int)i).provider);
                s = p.getService(type, name);
                if (s == null) continue;
                return s;
            }
        }
        for (i = 0; i < this.configs.length; ++i) {
            p = this.getProvider(i);
            s = p.getService(type, name);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public List<Provider.Service> getServices(String type, String algorithm) {
        return new ServiceList(type, algorithm);
    }

    @Deprecated
    public List<Provider.Service> getServices(String type, List<String> algorithms) {
        ArrayList<ServiceId> ids = new ArrayList<ServiceId>();
        for (String alg : algorithms) {
            ids.add(new ServiceId(type, alg));
        }
        return this.getServices(ids);
    }

    public List<Provider.Service> getServices(List<ServiceId> ids) {
        return new ServiceList(ids);
    }

    static final class PreferredList {
        ArrayList<PreferredEntry> list = new ArrayList();

        PreferredList() {
        }

        ArrayList<PreferredEntry> getAll(ServiceList s) {
            if (s.ids == null) {
                return this.getAll(s.type, s.algorithm);
            }
            ArrayList<PreferredEntry> l = new ArrayList<PreferredEntry>();
            for (ServiceId id : s.ids) {
                this.implGetAll(l, id.type, id.algorithm);
            }
            return l;
        }

        ArrayList<PreferredEntry> getAll(String type, String algorithm) {
            ArrayList<PreferredEntry> l = new ArrayList<PreferredEntry>();
            this.implGetAll(l, type, algorithm);
            return l;
        }

        private void implGetAll(ArrayList<PreferredEntry> l, String type, String algorithm) {
            for (int i = 0; i < this.size(); ++i) {
                PreferredEntry e = this.list.get(i);
                if (!e.match(type, algorithm)) continue;
                l.add(e);
            }
        }

        public PreferredEntry get(int i) {
            return this.list.get(i);
        }

        public int size() {
            return this.list.size();
        }

        public boolean add(PreferredEntry e) {
            return this.list.add(e);
        }

        public String toString() {
            String s = "";
            for (PreferredEntry e : this.list) {
                s = s + e.toString();
            }
            return s;
        }
    }

    private static class PreferredEntry {
        private String type = null;
        private String algorithm;
        private String provider;
        private String[] alternateNames = null;
        private boolean group = false;

        PreferredEntry(String t, String p) {
            int i = t.indexOf(46);
            if (i > 0) {
                this.type = t.substring(0, i);
                this.algorithm = t.substring(i + 1);
            } else {
                this.algorithm = t;
            }
            this.provider = p;
            if (this.type != null && this.type.compareToIgnoreCase("Group") == 0) {
                if (this.algorithm.compareToIgnoreCase("SHA2") == 0) {
                    this.alternateNames = SHA2Group;
                } else if (this.algorithm.compareToIgnoreCase("HmacSHA2") == 0) {
                    this.alternateNames = HmacSHA2Group;
                } else if (this.algorithm.compareToIgnoreCase("SHA2RSA") == 0) {
                    this.alternateNames = SHA2RSAGroup;
                } else if (this.algorithm.compareToIgnoreCase("SHA2DSA") == 0) {
                    this.alternateNames = SHA2DSAGroup;
                } else if (this.algorithm.compareToIgnoreCase("SHA2ECDSA") == 0) {
                    this.alternateNames = SHA2ECDSAGroup;
                } else if (this.algorithm.compareToIgnoreCase("SHA3") == 0) {
                    this.alternateNames = SHA3Group;
                } else if (this.algorithm.compareToIgnoreCase("HmacSHA3") == 0) {
                    this.alternateNames = HmacSHA3Group;
                }
                if (this.alternateNames != null) {
                    this.group = true;
                }
            } else if (this.algorithm.compareToIgnoreCase("SHA1") == 0) {
                this.alternateNames = new String[]{"SHA-1"};
            } else if (this.algorithm.compareToIgnoreCase("SHA-1") == 0) {
                this.alternateNames = new String[]{"SHA1"};
            }
        }

        boolean match(String t, String a) {
            if (debug != null) {
                debug.println("Config check:  " + this.toString() + " == " + this.print(t, a, null));
            }
            if (this.type != null && !this.group && this.type.compareToIgnoreCase(t) != 0) {
                return false;
            }
            if (!this.group && a.compareToIgnoreCase(this.algorithm) == 0) {
                if (debug != null) {
                    debug.println("Config entry matched:  " + this.toString());
                }
                return true;
            }
            if (this.alternateNames != null) {
                for (String alt : this.alternateNames) {
                    if (debug != null) {
                        debug.println("AltName check:  " + this.print(this.type, alt, this.provider));
                    }
                    if (a.compareToIgnoreCase(alt) != 0) continue;
                    if (debug != null) {
                        debug.println("AltName entry matched:  " + this.provider);
                    }
                    return true;
                }
            }
            return false;
        }

        private String print(String t, String a, String p) {
            return "[" + (t != null ? t : "") + ", " + a + (p != null ? " : " + p : "") + "] ";
        }

        public String toString() {
            return this.print(this.type, this.algorithm, this.provider);
        }
    }

    private final class ServiceList
    extends AbstractList<Provider.Service> {
        private final String type;
        private final String algorithm;
        private final List<ServiceId> ids;
        private Provider.Service firstService;
        private List<Provider.Service> services;
        private int providerIndex = 0;
        ArrayList<PreferredEntry> preferredList = null;
        private int preferredIndex = 0;

        ServiceList(String type, String algorithm) {
            this.type = type;
            this.algorithm = algorithm;
            this.ids = null;
        }

        ServiceList(List<ServiceId> ids) {
            this.type = null;
            this.algorithm = null;
            this.ids = ids;
        }

        private void addService(Provider.Service s) {
            if (this.firstService == null) {
                this.firstService = s;
            } else {
                if (this.services == null) {
                    this.services = new ArrayList<Provider.Service>(4);
                    this.services.add(this.firstService);
                }
                this.services.add(s);
            }
        }

        /*
         * Unable to fully structure code
         */
        private Provider.Service tryGet(int index) {
            if (ProviderList.preferredPropList != null && this.preferredList == null) {
                this.preferredList = ProviderList.preferredPropList.getAll(this);
            }
            block0: while (true) {
                if (index == 0 && this.firstService != null) {
                    return this.firstService;
                }
                if (this.services != null && this.services.size() > index) {
                    return this.services.get(index);
                }
                if (this.providerIndex >= ProviderList.this.configs.length) {
                    return null;
                }
                if (this.preferredList != null && this.preferredIndex < this.preferredList.size()) {
                    entry = this.preferredList.get(this.preferredIndex++);
                    p = ProviderList.this.getProvider(entry.provider);
                    if (p == null) {
                        if (ProviderList.debug == null) continue;
                        ProviderList.debug.println("No provider found with name: " + entry.provider);
                        continue;
                    }
                } else {
                    p = ProviderList.this.getProvider(this.providerIndex++);
                }
                if (this.type != null) {
                    s = p.getService(this.type, this.algorithm);
                    if (s == null) continue;
                    this.addService(s);
                    continue;
                }
                var3_3 = this.ids.iterator();
                while (true) {
                    if (var3_3.hasNext()) ** break;
                    continue block0;
                    id = var3_3.next();
                    s = p.getService(id.type, id.algorithm);
                    if (s == null) continue;
                    this.addService(s);
                }
                break;
            }
        }

        @Override
        public Provider.Service get(int index) {
            Provider.Service s = this.tryGet(index);
            if (s == null) {
                throw new IndexOutOfBoundsException();
            }
            return s;
        }

        @Override
        public int size() {
            int n;
            if (this.services != null) {
                n = this.services.size();
            } else {
                int n2 = n = this.firstService != null ? 1 : 0;
            }
            while (this.tryGet(n) != null) {
                ++n;
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return this.tryGet(0) == null;
        }

        @Override
        public Iterator<Provider.Service> iterator() {
            return new Iterator<Provider.Service>(){
                int index;

                @Override
                public boolean hasNext() {
                    return ServiceList.this.tryGet(this.index) != null;
                }

                @Override
                public Provider.Service next() {
                    Provider.Service s = ServiceList.this.tryGet(this.index);
                    if (s == null) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

