/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.Provider;
import sun.security.jca.JCAUtil;
import sun.security.jca.ProviderList;
import sun.security.provider.Sun;
import sun.security.provider.VerificationProvider;
import sun.security.x509.AlgorithmId;

public class Providers {
    private static final ThreadLocal<ProviderList> threadLists = new ThreadLocal();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static final String[] jarVerificationProviders;

    private Providers() {
    }

    public static Provider getSunProvider() {
        return new Sun();
    }

    public static Object startJarVerification() {
        ProviderList currentList = Providers.getProviderList();
        ProviderList jarList = currentList.getJarList(jarVerificationProviders);
        if (jarList.getProvider("SUN") == null) {
            VerificationProvider p;
            try {
                p = new VerificationProvider();
            }
            catch (Exception e) {
                throw new RuntimeException("Missing provider for jar verification", e);
            }
            ProviderList.add(jarList, p);
        }
        return Providers.beginThreadProviderList(jarList);
    }

    public static void stopJarVerification(Object obj) {
        Providers.endThreadProviderList((ProviderList)obj);
    }

    public static ProviderList getProviderList() {
        ProviderList list = Providers.getThreadProviderList();
        if (list == null) {
            list = Providers.getSystemProviderList();
        }
        return list;
    }

    public static void setProviderList(ProviderList newList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(newList);
        } else {
            Providers.changeThreadProviderList(newList);
        }
        Providers.clearCachedValues();
    }

    private static void clearCachedValues() {
        JCAUtil.clearDefSecureRandom();
        AlgorithmId.clearAliasOidsTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProviderList getFullProviderList() {
        Class<Providers> clazz = Providers.class;
        synchronized (Providers.class) {
            ProviderList list = Providers.getThreadProviderList();
            if (list != null) {
                ProviderList newList = list.removeInvalid();
                if (newList != list) {
                    Providers.changeThreadProviderList(newList);
                    list = newList;
                }
                // ** MonitorExit[var1] (shouldn't be in output)
                return list;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            list = Providers.getSystemProviderList();
            ProviderList newList = list.removeInvalid();
            if (newList != list) {
                Providers.setSystemProviderList(newList);
                list = newList;
            }
            return list;
        }
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList list) {
        providerList = list;
    }

    public static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return threadLists.get();
    }

    private static void changeThreadProviderList(ProviderList list) {
        threadLists.set(list);
    }

    public static synchronized ProviderList beginThreadProviderList(ProviderList list) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + list);
        }
        ProviderList oldList = threadLists.get();
        ++threadListsUsed;
        threadLists.set(list);
        return oldList;
    }

    public static synchronized void endThreadProviderList(ProviderList list) {
        if (list == null) {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Disabling ThreadLocal providers");
            }
            threadLists.remove();
        } else {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Restoring previous ThreadLocal providers: " + list);
            }
            threadLists.set(list);
        }
        --threadListsUsed;
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        jarVerificationProviders = new String[]{"SUN", "SunRsaSign", "SunEC", "SunJCE"};
    }
}

