/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.util.DerValue;
import sun.security.util.HexDumpEncoder;
import sun.security.x509.GeneralNames;
import sun.security.x509.SerialNumber;

class ESSCertId {
    private static volatile HexDumpEncoder hexDumper;
    private byte[] certHash;
    private GeneralNames issuer;
    private SerialNumber serialNumber;

    ESSCertId(DerValue certId) throws IOException {
        this.certHash = certId.data.getDerValue().toByteArray();
        if (certId.data.available() > 0) {
            DerValue issuerSerial = certId.data.getDerValue();
            this.issuer = new GeneralNames(issuerSerial.data.getDerValue());
            this.serialNumber = new SerialNumber(issuerSerial.data.getDerValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n\tCertificate hash (SHA-1):\n");
        if (hexDumper == null) {
            hexDumper = new HexDumpEncoder();
        }
        sb.append(hexDumper.encode(this.certHash));
        if (this.issuer != null && this.serialNumber != null) {
            sb.append("\n\tIssuer: " + this.issuer + "\n");
            sb.append("\t" + this.serialNumber);
        }
        sb.append("\n]");
        return sb.toString();
    }
}

