/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import sun.security.pkcs.ESSCertId;
import sun.security.util.DerValue;

public class SigningCertificateInfo {
    private byte[] ber = null;
    private ESSCertId[] certId = null;

    public SigningCertificateInfo(byte[] ber) throws IOException {
        this.parse(ber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.certId.length; ++i) {
            sb.append(this.certId[i].toString());
        }
        sb.append("\n]");
        return sb.toString();
    }

    public void parse(byte[] bytes) throws IOException {
        DerValue derValue = new DerValue(bytes);
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding for signingCertificate");
        }
        DerValue[] certs = derValue.data.getSequence(1);
        this.certId = new ESSCertId[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            this.certId[i] = new ESSCertId(certs[i]);
        }
        if (derValue.data.available() > 0) {
            DerValue[] policies = derValue.data.getSequence(1);
            for (int i = 0; i < policies.length; ++i) {
            }
        }
    }
}

