/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomParameters;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.provider.AbstractDrbg;

public class CtrDrbg
extends AbstractDrbg {
    private static final int AES_LIMIT;
    private Cipher cipher;
    private String cipherAlg;
    private String keyAlg;
    private int ctrLen;
    private int blockLen;
    private int keyLen;
    private int seedLen;
    private byte[] v;
    private byte[] k;

    public CtrDrbg(SecureRandomParameters params) {
        this.mechName = "CTR_DRBG";
        this.configure(params);
    }

    private static int alg2strength(String algorithm) {
        switch (algorithm.toUpperCase(Locale.ROOT)) {
            case "AES-128": {
                return 128;
            }
            case "AES-192": {
                return 192;
            }
            case "AES-256": {
                return 256;
            }
        }
        throw new IllegalArgumentException(algorithm + " not supported in CTR_DBRG");
    }

    @Override
    protected void chooseAlgorithmAndStrength() {
        if (this.requestedAlgorithm != null) {
            this.algorithm = this.requestedAlgorithm.toUpperCase(Locale.ROOT);
            int supportedStrength = CtrDrbg.alg2strength(this.algorithm);
            if (this.requestedInstantiationSecurityStrength >= 0) {
                int tryStrength = CtrDrbg.getStandardStrength(this.requestedInstantiationSecurityStrength);
                if (tryStrength > supportedStrength) {
                    throw new IllegalArgumentException(this.algorithm + " does not support strength " + this.requestedInstantiationSecurityStrength);
                }
                this.securityStrength = tryStrength;
            } else {
                this.securityStrength = 128 > supportedStrength ? supportedStrength : 128;
            }
        } else {
            int tryStrength = this.requestedInstantiationSecurityStrength < 0 ? 128 : this.requestedInstantiationSecurityStrength;
            if ((tryStrength = CtrDrbg.getStandardStrength(tryStrength)) <= 128 && AES_LIMIT < 256) {
                this.algorithm = "AES-128";
            } else if (AES_LIMIT >= 256) {
                this.algorithm = "AES-256";
            } else {
                throw new IllegalArgumentException("unsupported strength " + this.requestedInstantiationSecurityStrength);
            }
            this.securityStrength = tryStrength;
        }
        switch (this.algorithm.toUpperCase(Locale.ROOT)) {
            case "AES-128": 
            case "AES-192": 
            case "AES-256": {
                this.keyAlg = "AES";
                this.cipherAlg = "AES/ECB/NoPadding";
                switch (this.algorithm) {
                    case "AES-128": {
                        this.keyLen = 16;
                        break;
                    }
                    case "AES-192": {
                        this.keyLen = 24;
                        if (AES_LIMIT >= 192) break;
                        throw new IllegalArgumentException(this.algorithm + " not available (because policy) in CTR_DBRG");
                    }
                    case "AES-256": {
                        this.keyLen = 32;
                        if (AES_LIMIT >= 256) break;
                        throw new IllegalArgumentException(this.algorithm + " not available (because policy) in CTR_DBRG");
                    }
                    default: {
                        throw new IllegalArgumentException(this.algorithm + " not supported in CTR_DBRG");
                    }
                }
                this.blockLen = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.algorithm + " not supported in CTR_DBRG");
            }
        }
        this.seedLen = this.blockLen + this.keyLen;
        this.ctrLen = this.blockLen;
        if (this.usedf) {
            this.minLength = this.securityStrength / 8;
        } else {
            this.maxPersonalizationStringLength = this.maxAdditionalInputLength = this.seedLen;
            this.maxLength = this.maxAdditionalInputLength;
            this.minLength = this.maxAdditionalInputLength;
        }
    }

    @Override
    protected void initEngine() {
        try {
            this.cipher = Cipher.getInstance(this.cipherAlg, "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            try {
                this.cipher = Cipher.getInstance(this.cipherAlg);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException exc) {
                throw new InternalError("internal error: " + this.cipherAlg + " not available.", exc);
            }
        }
    }

    private void status() {
        if (debug != null) {
            debug.println(this, "Key = " + HexFormat.of().formatHex(this.k));
            debug.println(this, "V   = " + HexFormat.of().formatHex(this.v));
            debug.println(this, "reseed counter = " + this.reseedCounter);
        }
    }

    private void update(byte[] input) {
        if (input.length != this.seedLen) {
            throw new IllegalArgumentException("input length not seedLen: " + input.length);
        }
        try {
            int i;
            int m = (this.seedLen + this.blockLen - 1) / this.blockLen;
            byte[] temp = new byte[m * this.blockLen];
            for (i = 0; i < m; ++i) {
                CtrDrbg.addOne(this.v, this.ctrLen);
                this.cipher.init(1, new SecretKeySpec(this.k, this.keyAlg));
                this.cipher.doFinal(this.v, 0, this.blockLen, temp, i * this.blockLen);
            }
            temp = Arrays.copyOf(temp, this.seedLen);
            for (i = 0; i < this.seedLen; ++i) {
                int n = i;
                temp[n] = (byte)(temp[n] ^ input[i]);
            }
            this.k = Arrays.copyOf(temp, this.keyLen);
            this.v = Arrays.copyOfRange(temp, this.seedLen - this.blockLen, this.seedLen);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    @Override
    protected void instantiateAlgorithm(byte[] ei) {
        byte[] more;
        if (debug != null) {
            debug.println(this, "instantiate");
        }
        if (this.usedf) {
            if (this.personalizationString == null) {
                more = this.nonce;
            } else {
                if (this.nonce.length + this.personalizationString.length < 0) {
                    throw new IllegalArgumentException("nonce plus personalization string is too long");
                }
                more = Arrays.copyOf(this.nonce, this.nonce.length + this.personalizationString.length);
                System.arraycopy(this.personalizationString, 0, more, this.nonce.length, this.personalizationString.length);
            }
        } else {
            more = this.personalizationString;
        }
        this.reseedAlgorithm(ei, more);
    }

    private byte[] df(byte[] input) {
        int tailLen;
        int l = input.length;
        int n = this.seedLen;
        byte[] ln = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l, (byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        byte[] k = new byte[this.keyLen];
        for (int i = 0; i < k.length; ++i) {
            k[i] = (byte)i;
        }
        byte[] temp = new byte[this.seedLen];
        int i = 0;
        while (i * this.blockLen < temp.length) {
            byte[] iv = new byte[this.blockLen];
            iv[0] = (byte)(i >> 24);
            iv[1] = (byte)(i >> 16);
            iv[2] = (byte)(i >> 8);
            iv[3] = (byte)i;
            tailLen = temp.length - this.blockLen * i;
            if (tailLen > this.blockLen) {
                tailLen = this.blockLen;
            }
            System.arraycopy(this.bcc(k, iv, ln, input, {-128}), 0, temp, this.blockLen * i, tailLen);
            ++i;
        }
        k = Arrays.copyOf(temp, this.keyLen);
        byte[] x = Arrays.copyOfRange(temp, this.keyLen, temp.length);
        int i2 = 0;
        while (i2 * this.blockLen < this.seedLen) {
            try {
                this.cipher.init(1, new SecretKeySpec(k, this.keyAlg));
                tailLen = temp.length - this.blockLen * i2;
                if (tailLen > this.blockLen) {
                    tailLen = this.blockLen;
                }
                x = this.cipher.doFinal(x);
                System.arraycopy(x, 0, temp, this.blockLen * i2, tailLen);
            }
            catch (GeneralSecurityException e) {
                throw new InternalError(e);
            }
            ++i2;
        }
        return temp;
    }

    private byte[] bcc(byte[] k, byte[] ... data) {
        byte[] chain = new byte[this.blockLen];
        int n1 = 0;
        int n2 = 0;
        while (n1 < data.length) {
            int j = 0;
            block3: while (j < this.blockLen) {
                while (n2 >= data[n1].length) {
                    if (++n1 >= data.length) break block3;
                    n2 = 0;
                }
                int n = j++;
                chain[n] = (byte)(chain[n] ^ data[n1][n2]);
                ++n2;
            }
            if (j == 0) break;
            try {
                this.cipher.init(1, new SecretKeySpec(k, this.keyAlg));
                chain = this.cipher.doFinal(chain);
            }
            catch (GeneralSecurityException e) {
                throw new InternalError(e);
            }
        }
        return chain;
    }

    @Override
    protected synchronized void reseedAlgorithm(byte[] ei, byte[] additionalInput) {
        if (this.usedf) {
            if (additionalInput != null) {
                if (ei.length + additionalInput.length < 0) {
                    throw new IllegalArgumentException("entropy plus additional input is too long");
                }
                byte[] temp = Arrays.copyOf(ei, ei.length + additionalInput.length);
                System.arraycopy(additionalInput, 0, temp, ei.length, additionalInput.length);
                ei = temp;
            }
            ei = this.df(ei);
        } else if (additionalInput != null) {
            for (int i = 0; i < additionalInput.length; ++i) {
                int n = i;
                ei[n] = (byte)(ei[n] ^ additionalInput[i]);
            }
        }
        if (this.v == null) {
            this.k = new byte[this.keyLen];
            this.v = new byte[this.blockLen];
        }
        this.update(ei);
        this.reseedCounter = 1;
    }

    private static void addOne(byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            int n = data.length - 1 - i;
            data[n] = (byte)(data[n] + 1);
            if (data[data.length - 1 - i] != 0) break;
        }
    }

    @Override
    public synchronized void generateAlgorithm(byte[] result, byte[] additionalInput) {
        if (debug != null) {
            debug.println(this, "generateAlgorithm");
        }
        if (additionalInput != null) {
            additionalInput = this.usedf ? this.df(additionalInput) : Arrays.copyOf(additionalInput, this.seedLen);
            this.update(additionalInput);
        } else {
            additionalInput = new byte[this.seedLen];
        }
        int pos = 0;
        int len = result.length;
        while (len > 0) {
            CtrDrbg.addOne(this.v, this.ctrLen);
            try {
                this.cipher.init(1, new SecretKeySpec(this.k, this.keyAlg));
                if (len > this.blockLen) {
                    this.cipher.doFinal(this.v, 0, this.blockLen, result, pos);
                } else {
                    byte[] out = this.cipher.doFinal(this.v);
                    System.arraycopy(out, 0, result, pos, len);
                    Arrays.fill(out, (byte)0);
                }
            }
            catch (GeneralSecurityException e) {
                throw new InternalError(e);
            }
            if ((len -= this.blockLen) <= 0) break;
            pos += this.blockLen;
        }
        this.update(additionalInput);
        ++this.reseedCounter;
    }

    @Override
    public String toString() {
        return super.toString() + "," + (this.usedf ? "use_df" : "no_df");
    }

    static {
        try {
            AES_LIMIT = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (Exception e) {
            throw new AssertionError("Cannot detect AES", e);
        }
    }
}

