/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.provider.DSAPublicKeyImpl;

public class DSAKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec dsaPubKeySpec = (DSAPublicKeySpec)keySpec;
                return new DSAPublicKeyImpl(dsaPubKeySpec.getY(), dsaPubKeySpec.getP(), dsaPubKeySpec.getQ(), dsaPubKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        DSAPrivateKey dSAPrivateKey;
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec dsaPrivKeySpec = (DSAPrivateKeySpec)keySpec;
            return new DSAPrivateKey(dsaPrivKeySpec.getX(), dsaPrivKeySpec.getP(), dsaPrivKeySpec.getQ(), dsaPrivKeySpec.getG());
        }
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) throw new InvalidKeySpecException("Inappropriate key specification");
        byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
        try {
            dSAPrivateKey = new DSAPrivateKey(encoded);
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(encoded, (byte)0);
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
            }
        }
        Arrays.fill(encoded, (byte)0);
        return dSAPrivateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (keySpec.isAssignableFrom(dsaPubKeySpec)) {
                    java.security.interfaces.DSAPublicKey dsaPubKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams params = dsaPubKey.getParams();
                    return (T)((KeySpec)keySpec.cast(new DSAPublicKeySpec(dsaPubKey.getY(), params.getP(), params.getQ(), params.getG())));
                }
                if (!keySpec.isAssignableFrom(x509KeySpec)) throw new InvalidKeySpecException("Inappropriate key specification");
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            if (!(key instanceof java.security.interfaces.DSAPrivateKey)) throw new InvalidKeySpecException("Inappropriate key type");
            Class<?> dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
            Class<?> pkcs8KeySpec = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
            if (keySpec.isAssignableFrom(dsaPrivKeySpec)) {
                java.security.interfaces.DSAPrivateKey dsaPrivKey = (java.security.interfaces.DSAPrivateKey)key;
                DSAParams params = dsaPrivKey.getParams();
                return (T)((KeySpec)keySpec.cast(new DSAPrivateKeySpec(dsaPrivKey.getX(), params.getP(), params.getQ(), params.getG())));
            }
            if (!keySpec.isAssignableFrom(pkcs8KeySpec)) throw new InvalidKeySpecException("Inappropriate key specification");
            byte[] encoded = key.getEncoded();
            try {
                KeySpec keySpec2 = (KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(encoded));
                return (T)keySpec2;
            }
            finally {
                Arrays.fill(encoded, (byte)0);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dsaPubKeySpec = this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                return this.engineGeneratePublic(dsaPubKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dsaPrivKeySpec = this.engineGetKeySpec(key, DSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(dsaPrivKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }
}

