/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKeyImpl;
import sun.security.provider.ParameterCache;
import sun.security.util.SecurityProviderConstants;

class DSAKeyPairGenerator
extends KeyPairGenerator {
    private int plen;
    private int qlen;
    boolean forceNewParameters;
    private DSAParameterSpec params;
    private SecureRandom random;

    DSAKeyPairGenerator(int defaultKeySize) {
        super("DSA");
        this.initialize(defaultKeySize, null);
    }

    private static void checkStrength(int sizeP, int sizeQ) {
        if (!(sizeP >= 512 && sizeP <= 1024 && sizeP % 64 == 0 && sizeQ == 160 || sizeP == 2048 && (sizeQ == 224 || sizeQ == 256) || sizeP == 3072 && sizeQ == 256)) {
            throw new InvalidParameterException("Unsupported prime and subprime size combination: " + sizeP + ", " + sizeQ);
        }
    }

    @Override
    public void initialize(int modlen, SecureRandom random) {
        this.init(modlen, random, false);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.init((DSAParameterSpec)params, random, false);
    }

    void init(int modlen, SecureRandom random, boolean forceNew) {
        int subPrimeLen = SecurityProviderConstants.getDefDSASubprimeSize(modlen);
        DSAKeyPairGenerator.checkStrength(modlen, subPrimeLen);
        this.plen = modlen;
        this.qlen = subPrimeLen;
        this.params = null;
        this.random = random;
        this.forceNewParameters = forceNew;
    }

    void init(DSAParameterSpec params, SecureRandom random, boolean forceNew) {
        int sizeP = params.getP().bitLength();
        int sizeQ = params.getQ().bitLength();
        DSAKeyPairGenerator.checkStrength(sizeP, sizeQ);
        this.plen = sizeP;
        this.qlen = sizeQ;
        this.params = params;
        this.random = random;
        this.forceNewParameters = forceNew;
    }

    @Override
    public KeyPair generateKeyPair() {
        DSAParameterSpec spec;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            if (this.forceNewParameters) {
                spec = ParameterCache.getNewDSAParameterSpec(this.plen, this.qlen, this.random);
            } else {
                if (this.params == null) {
                    this.params = ParameterCache.getDSAParameterSpec(this.plen, this.qlen, this.random);
                }
                spec = this.params;
            }
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        return this.generateKeyPair(spec.getP(), spec.getQ(), spec.getG(), this.random);
    }

    private KeyPair generateKeyPair(BigInteger p, BigInteger q, BigInteger g, SecureRandom random) {
        BigInteger x = this.generateX(random, q);
        BigInteger y = this.generateY(x, p, g);
        try {
            DSAPublicKeyImpl pub = new DSAPublicKeyImpl(y, p, q, g);
            DSAPrivateKey priv = new DSAPrivateKey(x, p, q, g);
            KeyPair pair = new KeyPair(pub, priv);
            return pair;
        }
        catch (InvalidKeyException e) {
            throw new ProviderException(e);
        }
    }

    private BigInteger generateX(SecureRandom random, BigInteger q) {
        BigInteger x = null;
        byte[] temp = new byte[this.qlen];
        do {
            random.nextBytes(temp);
        } while ((x = new BigInteger(1, temp).mod(q)).signum() <= 0 || x.compareTo(q) >= 0);
        return x;
    }

    BigInteger generateY(BigInteger x, BigInteger p, BigInteger g) {
        BigInteger y = g.modPow(x, p);
        return y;
    }

    public static final class Legacy
    extends DSAKeyPairGenerator
    implements java.security.interfaces.DSAKeyPairGenerator {
        public Legacy() {
            super(1024);
        }

        @Override
        public void initialize(int modlen, boolean genParams, SecureRandom random) throws InvalidParameterException {
            if (genParams) {
                super.init(modlen, random, true);
            } else {
                DSAParameterSpec cachedParams = ParameterCache.getCachedDSAParameterSpec(modlen, SecurityProviderConstants.getDefDSASubprimeSize(modlen));
                if (cachedParams == null) {
                    throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
                }
                super.init(cachedParams, random, false);
            }
        }

        @Override
        public void initialize(DSAParams params, SecureRandom random) throws InvalidParameterException {
            if (params == null) {
                throw new InvalidParameterException("Params must not be null");
            }
            DSAParameterSpec spec = new DSAParameterSpec(params.getP(), params.getQ(), params.getG());
            super.init(spec, random, false);
        }
    }

    public static final class Current
    extends DSAKeyPairGenerator {
        public Current() {
            super(SecurityProviderConstants.DEF_DSA_KEY_SIZE);
        }
    }
}

