/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;

    public DSAPrivateKey(BigInteger x, BigInteger p, BigInteger q, BigInteger g) {
        this.x = x;
        this.algid = new AlgIdDSA(p, q, g);
        try {
            byte[] xbytes = x.toByteArray();
            DerValue val = new DerValue(2, xbytes);
            this.key = val.toByteArray();
            val.clear();
            Arrays.fill(xbytes, (byte)0);
        }
        catch (IOException e) {
            throw new AssertionError("Should not happen", e);
        }
    }

    public DSAPrivateKey(byte[] encoded) throws InvalidKeyException {
        super(encoded);
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.x = in.getBigInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }
}

