/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.DomainLoadStoreParameter;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import sun.security.provider.PolicyParser;
import sun.security.util.PolicyUtil;

abstract class DomainKeyStore
extends KeyStoreSpi {
    private static final String ENTRY_NAME_SEPARATOR = "entrynameseparator";
    private static final String KEYSTORE_PROVIDER_NAME = "keystoreprovidername";
    private static final String KEYSTORE_TYPE = "keystoretype";
    private static final String KEYSTORE_URI = "keystoreuri";
    private static final String KEYSTORE_PASSWORD_ENV = "keystorepasswordenv";
    private static final String REGEX_META = ".$|()[{^?*+\\";
    private static final String DEFAULT_STREAM_PREFIX = "iostream";
    private int streamCounter = 1;
    private String entryNameSeparator = " ";
    private String entryNameSeparatorRegEx = " ";
    private static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    private final Map<String, KeyStore> keystores = new HashMap<String, KeyStore>();

    DomainKeyStore() {
    }

    abstract String convertAlias(String var1);

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        Key key = null;
        try {
            KeyStore keystore;
            String entryAlias = pair.getKey();
            Iterator<KeyStore> iterator = pair.getValue().iterator();
            while (iterator.hasNext() && (key = (keystore = iterator.next()).getKey(entryAlias, password)) == null) {
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        Certificate[] chain = null;
        try {
            KeyStore keystore;
            String entryAlias = pair.getKey();
            Iterator<KeyStore> iterator = pair.getValue().iterator();
            while (iterator.hasNext() && (chain = (keystore = iterator.next()).getCertificateChain(entryAlias)) == null) {
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        Certificate cert = null;
        try {
            KeyStore keystore;
            String entryAlias = pair.getKey();
            Iterator<KeyStore> iterator = pair.getValue().iterator();
            while (iterator.hasNext() && (cert = (keystore = iterator.next()).getCertificate(entryAlias)) == null) {
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        Date date = null;
        try {
            KeyStore keystore;
            String entryAlias = pair.getKey();
            Iterator<KeyStore> iterator = pair.getValue().iterator();
            while (iterator.hasNext() && (date = (keystore = iterator.next()).getCreationDate(entryAlias)) == null) {
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return date;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> pair = this.getKeystoreForWriting(alias);
        if (pair == null) {
            throw new KeyStoreException("Error setting key entry for '" + alias + "'");
        }
        String entryAlias = pair.getKey();
        Map.Entry keystore = pair.getValue();
        ((KeyStore)keystore.getValue()).setKeyEntry(entryAlias, key, password, chain);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> pair = this.getKeystoreForWriting(alias);
        if (pair == null) {
            throw new KeyStoreException("Error setting protected key entry for '" + alias + "'");
        }
        String entryAlias = pair.getKey();
        Map.Entry keystore = pair.getValue();
        ((KeyStore)keystore.getValue()).setKeyEntry(entryAlias, key, chain);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> pair = this.getKeystoreForWriting(alias);
        if (pair == null) {
            throw new KeyStoreException("Error setting certificate entry for '" + alias + "'");
        }
        String entryAlias = pair.getKey();
        Map.Entry keystore = pair.getValue();
        ((KeyStore)keystore.getValue()).setCertificateEntry(entryAlias, cert);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> pair = this.getKeystoreForWriting(alias);
        if (pair == null) {
            throw new KeyStoreException("Error deleting entry for '" + alias + "'");
        }
        String entryAlias = pair.getKey();
        Map.Entry keystore = pair.getValue();
        ((KeyStore)keystore.getValue()).deleteEntry(entryAlias);
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<Map.Entry<String, KeyStore>> iterator = this.keystores.entrySet().iterator();
        return new Enumeration<String>(){
            private int index = 0;
            private Map.Entry<String, KeyStore> keystoresEntry = null;
            private String prefix = null;
            private Enumeration<String> aliases = null;

            @Override
            public boolean hasMoreElements() {
                try {
                    if (this.aliases == null) {
                        if (iterator.hasNext()) {
                            this.keystoresEntry = (Map.Entry)iterator.next();
                            this.prefix = this.keystoresEntry.getKey() + DomainKeyStore.this.entryNameSeparator;
                            this.aliases = this.keystoresEntry.getValue().aliases();
                        } else {
                            return false;
                        }
                    }
                    if (this.aliases.hasMoreElements()) {
                        return true;
                    }
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    this.keystoresEntry = (Map.Entry)iterator.next();
                    this.prefix = this.keystoresEntry.getKey() + DomainKeyStore.this.entryNameSeparator;
                    this.aliases = this.keystoresEntry.getValue().aliases();
                }
                catch (KeyStoreException e) {
                    return false;
                }
                return this.aliases.hasMoreElements();
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    return this.prefix + this.aliases.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        try {
            String entryAlias = pair.getKey();
            for (KeyStore keystore : pair.getValue()) {
                if (!keystore.containsAlias(entryAlias)) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }

    @Override
    public int engineSize() {
        int size = 0;
        try {
            for (KeyStore keystore : this.keystores.values()) {
                size += keystore.size();
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return size;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        try {
            String entryAlias = pair.getKey();
            for (KeyStore keystore : pair.getValue()) {
                if (!keystore.isKeyEntry(entryAlias)) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        AbstractMap.SimpleEntry<String, Collection<KeyStore>> pair = this.getKeystoresForReading(alias);
        try {
            String entryAlias = pair.getKey();
            for (KeyStore keystore : pair.getValue()) {
                if (!keystore.isCertificateEntry(entryAlias)) continue;
                return true;
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }

    private AbstractMap.SimpleEntry<String, Collection<KeyStore>> getKeystoresForReading(String alias) {
        String[] splits = alias.split(this.entryNameSeparatorRegEx, 2);
        if (splits.length == 2) {
            KeyStore keystore = this.keystores.get(splits[0]);
            if (keystore != null) {
                return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>(splits[1], Collections.singleton(keystore));
            }
        } else if (splits.length == 1) {
            return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>(alias, this.keystores.values());
        }
        return new AbstractMap.SimpleEntry<String, Collection<KeyStore>>("", Collections.emptyList());
    }

    private AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>> getKeystoreForWriting(String alias) {
        KeyStore keystore;
        String[] splits = alias.split(this.entryNameSeparator, 2);
        if (splits.length == 2 && (keystore = this.keystores.get(splits[0])) != null) {
            return new AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<String, KeyStore>>(splits[1], new AbstractMap.SimpleEntry<String, KeyStore>(splits[0], keystore));
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            KeyStore keystore;
            String alias = null;
            Iterator<KeyStore> iterator = this.keystores.values().iterator();
            while (iterator.hasNext() && (alias = (keystore = iterator.next()).getCertificateAlias(cert)) == null) {
            }
            return alias;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            if (this.keystores.size() == 1) {
                this.keystores.values().iterator().next().store(stream, password);
                return;
            }
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
        throw new UnsupportedOperationException("This keystore must be stored using a DomainLoadStoreParameter");
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param instanceof DomainLoadStoreParameter) {
            DomainLoadStoreParameter domainParameter = (DomainLoadStoreParameter)param;
            List<KeyStoreBuilderComponents> builders = this.getBuilders(domainParameter.getConfiguration(), domainParameter.getProtectionParams());
            for (KeyStoreBuilderComponents builder : builders) {
                try {
                    KeyStore.ProtectionParameter pp = builder.protection;
                    if (!(pp instanceof KeyStore.PasswordProtection)) {
                        throw new KeyStoreException(new IllegalArgumentException("ProtectionParameter must be a KeyStore.PasswordProtection"));
                    }
                    char[] password = ((KeyStore.PasswordProtection)builder.protection).getPassword();
                    KeyStore keystore = this.keystores.get(builder.name);
                    try (FileOutputStream stream = new FileOutputStream(builder.file);){
                        keystore.store(stream, password);
                    }
                }
                catch (KeyStoreException e) {
                    throw new IOException(e);
                }
            }
        } else {
            throw new UnsupportedOperationException("This keystore must be stored using a DomainLoadStoreParameter");
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            KeyStore keystore = null;
            try {
                keystore = KeyStore.getInstance("JKS");
                keystore.load(stream, password);
            }
            catch (Exception e) {
                if (!"JKS".equalsIgnoreCase(DEFAULT_KEYSTORE_TYPE)) {
                    keystore = KeyStore.getInstance(DEFAULT_KEYSTORE_TYPE);
                    keystore.load(stream, password);
                }
                throw e;
            }
            String keystoreName = DEFAULT_STREAM_PREFIX + this.streamCounter++;
            this.keystores.put(keystoreName, keystore);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("This keystore must be loaded using a DomainLoadStoreParameter");
        }
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param instanceof DomainLoadStoreParameter) {
            DomainLoadStoreParameter domainParameter = (DomainLoadStoreParameter)param;
            List<KeyStoreBuilderComponents> builders = this.getBuilders(domainParameter.getConfiguration(), domainParameter.getProtectionParams());
            for (KeyStoreBuilderComponents builder : builders) {
                try {
                    if (builder.file != null) {
                        this.keystores.put(builder.name, KeyStore.Builder.newInstance(builder.type, builder.provider, builder.file, builder.protection).getKeyStore());
                        continue;
                    }
                    this.keystores.put(builder.name, KeyStore.Builder.newInstance(builder.type, builder.provider, builder.protection).getKeyStore());
                }
                catch (KeyStoreException e) {
                    throw new IOException(e);
                }
            }
        } else {
            throw new UnsupportedOperationException("This keystore must be loaded using a DomainLoadStoreParameter");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<KeyStoreBuilderComponents> getBuilders(URI configuration, Map<String, KeyStore.ProtectionParameter> passwords) throws IOException {
        PolicyParser parser = new PolicyParser(true);
        Collection<PolicyParser.DomainEntry> domains = null;
        ArrayList<KeyStoreBuilderComponents> builders = new ArrayList<KeyStoreBuilderComponents>();
        String uriDomain = configuration.getFragment();
        try (InputStreamReader configurationReader = new InputStreamReader(PolicyUtil.getInputStream(configuration.toURL()), StandardCharsets.UTF_8);){
            parser.read(configurationReader);
            domains = parser.getDomainEntries();
        }
        catch (MalformedURLException mue) {
            throw new IOException(mue);
        }
        catch (PolicyParser.ParsingException pe) {
            throw new IOException(pe);
        }
        for (PolicyParser.DomainEntry domain : domains) {
            Map<String, String> domainProperties = domain.getProperties();
            if (uriDomain != null && !uriDomain.equalsIgnoreCase(domain.getName())) continue;
            if (domainProperties.containsKey(ENTRY_NAME_SEPARATOR)) {
                this.entryNameSeparator = domainProperties.get(ENTRY_NAME_SEPARATOR);
                char ch = '\u0000';
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < this.entryNameSeparator.length(); ++i) {
                    ch = this.entryNameSeparator.charAt(i);
                    if (REGEX_META.indexOf(ch) != -1) {
                        s.append('\\');
                    }
                    s.append(ch);
                }
                this.entryNameSeparatorRegEx = s.toString();
            }
            Collection<PolicyParser.KeyStoreEntry> keystores = domain.getEntries();
            for (PolicyParser.KeyStoreEntry keystore : keystores) {
                String keystoreProviderName;
                String keystoreName = keystore.getName();
                HashMap<String, String> properties = new HashMap<String, String>(domainProperties);
                properties.putAll(keystore.getProperties());
                String keystoreType = DEFAULT_KEYSTORE_TYPE;
                if (properties.containsKey(KEYSTORE_TYPE)) {
                    keystoreType = (String)properties.get(KEYSTORE_TYPE);
                }
                Provider keystoreProvider = null;
                if (properties.containsKey(KEYSTORE_PROVIDER_NAME) && (keystoreProvider = Security.getProvider(keystoreProviderName = (String)properties.get(KEYSTORE_PROVIDER_NAME))) == null) {
                    throw new IOException("Error locating JCE provider: " + keystoreProviderName);
                }
                File keystoreFile = null;
                if (properties.containsKey(KEYSTORE_URI)) {
                    String uri = (String)properties.get(KEYSTORE_URI);
                    try {
                        keystoreFile = uri.startsWith("file://") ? new File(new URI(uri)) : new File(uri);
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        throw new IOException("Error processing keystore property: keystoreURI=\"" + uri + "\"", e);
                    }
                }
                KeyStore.ProtectionParameter keystoreProtection = null;
                if (passwords.containsKey(keystoreName)) {
                    keystoreProtection = passwords.get(keystoreName);
                } else if (properties.containsKey(KEYSTORE_PASSWORD_ENV)) {
                    String env = (String)properties.get(KEYSTORE_PASSWORD_ENV);
                    String pwd = System.getenv(env);
                    if (pwd == null) throw new IOException("Error processing keystore property: keystorePasswordEnv=\"" + env + "\"");
                    keystoreProtection = new KeyStore.PasswordProtection(pwd.toCharArray());
                } else {
                    keystoreProtection = new KeyStore.PasswordProtection(null);
                }
                builders.add(new KeyStoreBuilderComponents(keystoreName, keystoreType, keystoreProvider, keystoreFile, keystoreProtection));
            }
        }
        if (!builders.isEmpty()) return builders;
        throw new IOException("Error locating domain configuration data for: " + configuration);
    }

    static class KeyStoreBuilderComponents {
        String name;
        String type;
        Provider provider;
        File file;
        KeyStore.ProtectionParameter protection;

        KeyStoreBuilderComponents(String name, String type, Provider provider, File file, KeyStore.ProtectionParameter protection) {
            this.name = name;
            this.type = type;
            this.provider = provider;
            this.file = file;
            this.protection = protection;
        }
    }

    public static final class DKS
    extends DomainKeyStore {
        @Override
        String convertAlias(String alias) {
            return alias.toLowerCase(Locale.ENGLISH);
        }
    }
}

