/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class FileInputStreamPool {
    private static final ConcurrentMap<File, StreamRef> pool = new ConcurrentHashMap<File, StreamRef>();
    private static final ReferenceQueue<UnclosableInputStream> refQueue = new ReferenceQueue();

    FileInputStreamPool() {
    }

    static InputStream getInputStream(File file) throws IOException {
        StreamRef oldRref;
        while ((oldRref = (StreamRef)refQueue.poll()) != null) {
            pool.remove(oldRref.file, oldRref);
        }
        File cfile = file.getCanonicalFile();
        oldRref = (StreamRef)pool.get(cfile);
        UnclosableInputStream oldStream = oldRref == null ? null : (UnclosableInputStream)oldRref.get();
        StreamRef newRef = null;
        UnclosableInputStream newStream = null;
        while (true) {
            if (oldStream != null) {
                if (newStream != null) {
                    try {
                        newStream.getWrappedStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return oldStream;
            }
            if (newStream == null) {
                newStream = new UnclosableInputStream(new FileInputStream(cfile));
                newRef = new StreamRef(cfile, newStream, refQueue);
            }
            if (oldRref == null) {
                oldRref = pool.putIfAbsent(cfile, newRef);
            } else {
                StreamRef streamRef = oldRref = pool.replace(cfile, oldRref, newRef) ? null : (StreamRef)pool.get(cfile);
            }
            if (oldRref == null) {
                return newStream;
            }
            oldStream = (UnclosableInputStream)oldRref.get();
        }
    }

    private static class StreamRef
    extends WeakReference<UnclosableInputStream> {
        final File file;

        StreamRef(File file, UnclosableInputStream stream, ReferenceQueue<UnclosableInputStream> refQueue) {
            super(stream, refQueue);
            this.file = file;
        }
    }

    private static final class UnclosableInputStream
    extends FilterInputStream {
        UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }

        InputStream getWrappedStream() {
            return this.in;
        }
    }
}

