/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomParameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.HexFormat;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.security.provider.AbstractHashDrbg;

public class HmacDrbg
extends AbstractHashDrbg {
    private Mac mac;
    private String macAlg;
    private byte[] v;
    private byte[] k;

    public HmacDrbg(SecureRandomParameters params) {
        this.mechName = "HMAC_DRBG";
        this.configure(params);
    }

    private void status() {
        if (debug != null) {
            debug.println(this, "V = " + HexFormat.of().formatHex(this.v));
            debug.println(this, "Key = " + HexFormat.of().formatHex(this.k));
            debug.println(this, "reseed counter = " + this.reseedCounter);
        }
    }

    private void update(List<byte[]> inputs) {
        try {
            this.mac.init(new SecretKeySpec(this.k, this.macAlg));
            this.mac.update(this.v);
            this.mac.update((byte)0);
            for (byte[] input : inputs) {
                this.mac.update(input);
            }
            this.k = this.mac.doFinal();
            this.mac.init(new SecretKeySpec(this.k, this.macAlg));
            this.v = this.mac.doFinal(this.v);
            if (!inputs.isEmpty()) {
                this.mac.update(this.v);
                this.mac.update((byte)1);
                for (byte[] input : inputs) {
                    this.mac.update(input);
                }
                this.k = this.mac.doFinal();
                this.mac.init(new SecretKeySpec(this.k, this.macAlg));
                this.v = this.mac.doFinal(this.v);
            }
        }
        catch (InvalidKeyException e) {
            throw new InternalError(e);
        }
    }

    @Override
    protected void initEngine() {
        this.macAlg = "HmacSHA" + this.algorithm.substring(4);
        try {
            this.mac = Mac.getInstance(this.macAlg, "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            try {
                this.mac = Mac.getInstance(this.macAlg);
            }
            catch (NoSuchAlgorithmException exc) {
                throw new InternalError("internal error: " + this.macAlg + " not available.", exc);
            }
        }
    }

    @Override
    protected final synchronized void hashReseedInternal(List<byte[]> input) {
        if (this.v == null) {
            this.k = new byte[this.outLen];
            this.v = new byte[this.outLen];
            Arrays.fill(this.v, (byte)1);
        }
        this.update(input);
        this.reseedCounter = 1;
    }

    @Override
    public synchronized void generateAlgorithm(byte[] result, byte[] additionalInput) {
        if (debug != null) {
            debug.println(this, "generateAlgorithm");
        }
        if (additionalInput != null) {
            this.update(Collections.singletonList(additionalInput));
        }
        int pos = 0;
        int len = result.length;
        while (len > 0) {
            try {
                this.mac.init(new SecretKeySpec(this.k, this.macAlg));
            }
            catch (InvalidKeyException e) {
                throw new InternalError(e);
            }
            this.v = this.mac.doFinal(this.v);
            System.arraycopy(this.v, 0, result, pos, len > this.outLen ? this.outLen : len);
            if ((len -= this.outLen) <= 0) break;
            pos += this.outLen;
        }
        if (additionalInput != null) {
            this.update(Collections.singletonList(additionalInput));
        } else {
            this.update(Collections.emptyList());
        }
        ++this.reseedCounter;
    }
}

