/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

final class KeyProtector {
    private static final int SALT_LEN = 20;
    private static final String DIGEST_ALG = "SHA";
    private static final int DIGEST_LEN = 20;
    private byte[] passwdBytes;
    private MessageDigest md;

    public KeyProtector(byte[] passwordBytes) throws NoSuchAlgorithmException {
        if (passwordBytes == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        this.md = MessageDigest.getInstance(DIGEST_ALG);
        this.passwdBytes = passwordBytes;
    }

    public byte[] protect(Key key) throws KeyStoreException {
        int encrKeyOffset = 0;
        if (key == null) {
            throw new IllegalArgumentException("plaintext key can't be null");
        }
        if (!"PKCS#8".equalsIgnoreCase(key.getFormat())) {
            throw new KeyStoreException("Cannot get key bytes, not PKCS#8 encoded");
        }
        byte[] plainKey = key.getEncoded();
        if (plainKey == null) {
            throw new KeyStoreException("Cannot get key bytes, encoding not supported");
        }
        int numRounds = plainKey.length / 20;
        if (plainKey.length % 20 != 0) {
            ++numRounds;
        }
        byte[] salt = new byte[20];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        byte[] xorKey = new byte[plainKey.length];
        int i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.passwdBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorKey, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorKey, xorOffset, xorKey.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] tmpKey = new byte[plainKey.length];
        for (i = 0; i < tmpKey.length; ++i) {
            tmpKey[i] = (byte)(plainKey[i] ^ xorKey[i]);
        }
        byte[] encrKey = new byte[salt.length + tmpKey.length + 20];
        System.arraycopy(salt, 0, encrKey, encrKeyOffset, salt.length);
        System.arraycopy(tmpKey, 0, encrKey, encrKeyOffset += salt.length, tmpKey.length);
        encrKeyOffset += tmpKey.length;
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(plainKey);
        digest = this.md.digest();
        this.md.reset();
        System.arraycopy(digest, 0, encrKey, encrKeyOffset, digest.length);
        Arrays.fill(plainKey, (byte)0);
        try {
            AlgorithmId encrAlg = new AlgorithmId(ObjectIdentifier.of(KnownOIDs.JAVASOFT_JDKKeyProtector));
            return new EncryptedPrivateKeyInfo(encrAlg, encrKey).getEncoded();
        }
        catch (IOException ioe) {
            throw new KeyStoreException(ioe.getMessage());
        }
    }

    public Key recover(EncryptedPrivateKeyInfo encrInfo) throws UnrecoverableKeyException {
        AlgorithmId encrAlg = encrInfo.getAlgorithm();
        if (!encrAlg.getOID().toString().equals(KnownOIDs.JAVASOFT_JDKKeyProtector.value())) {
            throw new UnrecoverableKeyException("Unsupported key protection algorithm");
        }
        byte[] protectedKey = encrInfo.getEncryptedData();
        byte[] salt = new byte[20];
        System.arraycopy(protectedKey, 0, salt, 0, 20);
        int encrKeyLen = protectedKey.length - 20 - 20;
        int numRounds = encrKeyLen / 20;
        if (encrKeyLen % 20 != 0) {
            ++numRounds;
        }
        byte[] encrKey = new byte[encrKeyLen];
        System.arraycopy(protectedKey, 20, encrKey, 0, encrKeyLen);
        byte[] xorKey = new byte[encrKey.length];
        int i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.passwdBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorKey, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorKey, xorOffset, xorKey.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] plainKey = new byte[encrKey.length];
        for (i = 0; i < plainKey.length; ++i) {
            plainKey[i] = (byte)(encrKey[i] ^ xorKey[i]);
        }
        this.md.update(this.passwdBytes);
        Arrays.fill(this.passwdBytes, (byte)0);
        this.passwdBytes = null;
        this.md.update(plainKey);
        digest = this.md.digest();
        this.md.reset();
        for (i = 0; i < digest.length; ++i) {
            if (digest[i] == protectedKey[20 + encrKeyLen + i]) continue;
            throw new UnrecoverableKeyException("Cannot recover key");
        }
        try {
            PrivateKey privateKey = PKCS8Key.parseKey(plainKey);
            return privateKey;
        }
        catch (IOException ioe) {
            throw new UnrecoverableKeyException(ioe.getMessage());
        }
        finally {
            Arrays.fill(plainKey, (byte)0);
        }
    }
}

