/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;
import sun.security.util.SecurityConstants;

public final class MD4
extends DigestBase {
    private int[] state = new int[4];
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;
    private static final Provider md4Provider = new Provider("MD4Provider", SecurityConstants.PROVIDER_VER, "MD4 MessageDigest"){
        private static final long serialVersionUID = -8850464997518327965L;
    };

    public static MessageDigest getInstance() {
        try {
            return MessageDigest.getInstance("MD4", md4Provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
    }

    public MD4() {
        super("MD4", 16, 64);
        this.resetHashes();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MD4 copy = (MD4)super.clone();
        copy.state = (int[])copy.state.clone();
        return copy;
    }

    @Override
    void implReset() {
        this.resetHashes();
    }

    private void resetHashes() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    @Override
    void implDigest(byte[] out, int ofs) {
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.engineUpdate(padding, 0, padLen);
        ByteArrayAccess.i2bLittle4((int)bitsProcessed, this.buffer, 56);
        ByteArrayAccess.i2bLittle4((int)(bitsProcessed >>> 32), this.buffer, 60);
        this.implCompress(this.buffer, 0);
        ByteArrayAccess.i2bLittle(this.state, 0, out, ofs, 16);
    }

    private static int FF(int a, int b, int c, int d, int x, int s) {
        return (a += (b & c | ~b & d) + x) << s | a >>> 32 - s;
    }

    private static int GG(int a, int b, int c, int d, int x, int s) {
        return (a += (b & c | b & d | c & d) + x + 1518500249) << s | a >>> 32 - s;
    }

    private static int HH(int a, int b, int c, int d, int x, int s) {
        return (a += (b ^ c ^ d) + x + 1859775393) << s | a >>> 32 - s;
    }

    @Override
    void implCompress(byte[] buf, int ofs) {
        int x0 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs);
        int x1 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 4);
        int x2 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 8);
        int x3 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 12);
        int x4 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 16);
        int x5 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 20);
        int x6 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 24);
        int x7 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 28);
        int x8 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 32);
        int x9 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 36);
        int x10 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 40);
        int x11 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 44);
        int x12 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 48);
        int x13 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 52);
        int x14 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 56);
        int x15 = ByteArrayAccess.LE.INT_ARRAY.get(buf, ofs + 60);
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        a = MD4.FF(a, b, c, d, x0, 3);
        d = MD4.FF(d, a, b, c, x1, 7);
        c = MD4.FF(c, d, a, b, x2, 11);
        b = MD4.FF(b, c, d, a, x3, 19);
        a = MD4.FF(a, b, c, d, x4, 3);
        d = MD4.FF(d, a, b, c, x5, 7);
        c = MD4.FF(c, d, a, b, x6, 11);
        b = MD4.FF(b, c, d, a, x7, 19);
        a = MD4.FF(a, b, c, d, x8, 3);
        d = MD4.FF(d, a, b, c, x9, 7);
        c = MD4.FF(c, d, a, b, x10, 11);
        b = MD4.FF(b, c, d, a, x11, 19);
        a = MD4.FF(a, b, c, d, x12, 3);
        d = MD4.FF(d, a, b, c, x13, 7);
        c = MD4.FF(c, d, a, b, x14, 11);
        b = MD4.FF(b, c, d, a, x15, 19);
        a = MD4.GG(a, b, c, d, x0, 3);
        d = MD4.GG(d, a, b, c, x4, 5);
        c = MD4.GG(c, d, a, b, x8, 9);
        b = MD4.GG(b, c, d, a, x12, 13);
        a = MD4.GG(a, b, c, d, x1, 3);
        d = MD4.GG(d, a, b, c, x5, 5);
        c = MD4.GG(c, d, a, b, x9, 9);
        b = MD4.GG(b, c, d, a, x13, 13);
        a = MD4.GG(a, b, c, d, x2, 3);
        d = MD4.GG(d, a, b, c, x6, 5);
        c = MD4.GG(c, d, a, b, x10, 9);
        b = MD4.GG(b, c, d, a, x14, 13);
        a = MD4.GG(a, b, c, d, x3, 3);
        d = MD4.GG(d, a, b, c, x7, 5);
        c = MD4.GG(c, d, a, b, x11, 9);
        b = MD4.GG(b, c, d, a, x15, 13);
        a = MD4.HH(a, b, c, d, x0, 3);
        d = MD4.HH(d, a, b, c, x8, 9);
        c = MD4.HH(c, d, a, b, x4, 11);
        b = MD4.HH(b, c, d, a, x12, 15);
        a = MD4.HH(a, b, c, d, x2, 3);
        d = MD4.HH(d, a, b, c, x10, 9);
        c = MD4.HH(c, d, a, b, x6, 11);
        b = MD4.HH(b, c, d, a, x14, 15);
        a = MD4.HH(a, b, c, d, x1, 3);
        d = MD4.HH(d, a, b, c, x9, 9);
        c = MD4.HH(c, d, a, b, x5, 11);
        b = MD4.HH(b, c, d, a, x13, 15);
        a = MD4.HH(a, b, c, d, x3, 3);
        d = MD4.HH(d, a, b, c, x11, 9);
        c = MD4.HH(c, d, a, b, x7, 11);
        b = MD4.HH(b, c, d, a, x15, 15);
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
    }

    static {
        Void void_ = AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                md4Provider.put("MessageDigest.MD4", "sun.security.provider.MD4");
                return null;
            }
        });
    }
}

