/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.ProviderException;
import java.util.Arrays;
import java.util.Objects;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

abstract class SHA3
extends DigestBase {
    private static final int WIDTH = 200;
    private static final int DM = 5;
    private static final int NR = 24;
    private static final long[] RC_CONSTANTS = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private final byte suffix;
    private byte[] state = new byte[200];
    private long[] lanes = new long[25];

    SHA3(String name, int digestLength, byte suffix, int c) {
        super(name, digestLength, 200 - c);
        this.suffix = suffix;
    }

    private void implCompressCheck(byte[] b, int ofs) {
        Objects.requireNonNull(b);
    }

    @Override
    void implCompress(byte[] b, int ofs) {
        this.implCompressCheck(b, ofs);
        this.implCompress0(b, ofs);
    }

    @IntrinsicCandidate
    private void implCompress0(byte[] b, int ofs) {
        int i = 0;
        while (i < this.buffer.length) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ b[ofs++]);
        }
        this.keccak();
    }

    @Override
    void implDigest(byte[] out, int ofs) {
        int numOfPadding = SHA3.setPaddingBytes(this.suffix, this.buffer, (int)(this.bytesProcessed % (long)this.buffer.length));
        if (numOfPadding < 1) {
            throw new ProviderException("Incorrect pad size: " + numOfPadding);
        }
        this.implCompress(this.buffer, 0);
        System.arraycopy(this.state, 0, out, ofs, this.engineGetDigestLength());
    }

    @Override
    void implReset() {
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.lanes, 0L);
    }

    private static int setPaddingBytes(byte suffix, byte[] in, int len) {
        if (len != in.length) {
            Arrays.fill(in, len, in.length, (byte)0);
            int n = len;
            in[n] = (byte)(in[n] | suffix);
            int n2 = in.length - 1;
            in[n2] = (byte)(in[n2] | 0xFFFFFF80);
        }
        return in.length - len;
    }

    private static void bytes2Lanes(byte[] s, long[] m) {
        int sOfs = 0;
        int y = 0;
        while (y < 5) {
            ByteArrayAccess.b2lLittle(s, sOfs, m, 5 * y, 40);
            ++y;
            sOfs += 40;
        }
    }

    private static void lanes2Bytes(long[] m, byte[] s) {
        int sOfs = 0;
        int y = 0;
        while (y < 5) {
            ByteArrayAccess.l2bLittle(m, 5 * y, s, sOfs, 40);
            ++y;
            sOfs += 40;
        }
    }

    private static long[] smTheta(long[] a) {
        long c0 = a[0] ^ a[5] ^ a[10] ^ a[15] ^ a[20];
        long c1 = a[1] ^ a[6] ^ a[11] ^ a[16] ^ a[21];
        long c2 = a[2] ^ a[7] ^ a[12] ^ a[17] ^ a[22];
        long c3 = a[3] ^ a[8] ^ a[13] ^ a[18] ^ a[23];
        long c4 = a[4] ^ a[9] ^ a[14] ^ a[19] ^ a[24];
        long d0 = c4 ^ Long.rotateLeft(c1, 1);
        long d1 = c0 ^ Long.rotateLeft(c2, 1);
        long d2 = c1 ^ Long.rotateLeft(c3, 1);
        long d3 = c2 ^ Long.rotateLeft(c4, 1);
        long d4 = c3 ^ Long.rotateLeft(c0, 1);
        for (int y = 0; y < a.length; y += 5) {
            int n = y;
            a[n] = a[n] ^ d0;
            int n2 = y + 1;
            a[n2] = a[n2] ^ d1;
            int n3 = y + 2;
            a[n3] = a[n3] ^ d2;
            int n4 = y + 3;
            a[n4] = a[n4] ^ d3;
            int n5 = y + 4;
            a[n5] = a[n5] ^ d4;
        }
        return a;
    }

    private static long[] smPiRho(long[] a) {
        long tmp = Long.rotateLeft(a[10], 3);
        a[10] = Long.rotateLeft(a[1], 1);
        a[1] = Long.rotateLeft(a[6], 44);
        a[6] = Long.rotateLeft(a[9], 20);
        a[9] = Long.rotateLeft(a[22], 61);
        a[22] = Long.rotateLeft(a[14], 39);
        a[14] = Long.rotateLeft(a[20], 18);
        a[20] = Long.rotateLeft(a[2], 62);
        a[2] = Long.rotateLeft(a[12], 43);
        a[12] = Long.rotateLeft(a[13], 25);
        a[13] = Long.rotateLeft(a[19], 8);
        a[19] = Long.rotateLeft(a[23], 56);
        a[23] = Long.rotateLeft(a[15], 41);
        a[15] = Long.rotateLeft(a[4], 27);
        a[4] = Long.rotateLeft(a[24], 14);
        a[24] = Long.rotateLeft(a[21], 2);
        a[21] = Long.rotateLeft(a[8], 55);
        a[8] = Long.rotateLeft(a[16], 45);
        a[16] = Long.rotateLeft(a[5], 36);
        a[5] = Long.rotateLeft(a[3], 28);
        a[3] = Long.rotateLeft(a[18], 21);
        a[18] = Long.rotateLeft(a[17], 15);
        a[17] = Long.rotateLeft(a[11], 10);
        a[11] = Long.rotateLeft(a[7], 6);
        a[7] = tmp;
        return a;
    }

    private static long[] smChi(long[] a) {
        for (int y = 0; y < a.length; y += 5) {
            long ay0 = a[y];
            long ay1 = a[y + 1];
            long ay2 = a[y + 2];
            long ay3 = a[y + 3];
            long ay4 = a[y + 4];
            a[y] = ay0 ^ (ay1 ^ 0xFFFFFFFFFFFFFFFFL) & ay2;
            a[y + 1] = ay1 ^ (ay2 ^ 0xFFFFFFFFFFFFFFFFL) & ay3;
            a[y + 2] = ay2 ^ (ay3 ^ 0xFFFFFFFFFFFFFFFFL) & ay4;
            a[y + 3] = ay3 ^ (ay4 ^ 0xFFFFFFFFFFFFFFFFL) & ay0;
            a[y + 4] = ay4 ^ (ay0 ^ 0xFFFFFFFFFFFFFFFFL) & ay1;
        }
        return a;
    }

    private static long[] smIota(long[] a, int rndIndex) {
        a[0] = a[0] ^ RC_CONSTANTS[rndIndex];
        return a;
    }

    private void keccak() {
        SHA3.bytes2Lanes(this.state, this.lanes);
        for (int ir = 0; ir < 24; ++ir) {
            SHA3.smIota(SHA3.smChi(SHA3.smPiRho(SHA3.smTheta(this.lanes))), ir);
        }
        SHA3.lanes2Bytes(this.lanes, this.state);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SHA3 copy = (SHA3)super.clone();
        copy.state = (byte[])copy.state.clone();
        copy.lanes = new long[25];
        return copy;
    }

    public static final class SHA512
    extends SHA3 {
        public SHA512() {
            super("SHA3-512", 64, (byte)6, 128);
        }
    }

    public static final class SHA384
    extends SHA3 {
        public SHA384() {
            super("SHA3-384", 48, (byte)6, 96);
        }
    }

    public static final class SHA256
    extends SHA3 {
        public SHA256() {
            super("SHA3-256", 32, (byte)6, 64);
        }
    }

    public static final class SHA224
    extends SHA3 {
        public SHA224() {
            super("SHA3-224", 28, (byte)6, 56);
        }
    }
}

