/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import jdk.internal.util.StaticProperty;
import sun.security.action.GetPropertyAction;
import sun.security.provider.NativePRNG;
import sun.security.util.SecurityProviderConstants;

public final class SunEntries {
    public static final String DEF_SECURE_RANDOM_ALGO;
    private LinkedHashSet<Provider.Service> services = new LinkedHashSet(50, 0.9f);
    private static final String PROP_EGD = "java.security.egd";
    private static final String PROP_RNDSOURCE = "securerandom.source";
    private static final boolean useLegacyDSA;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";
    private static final String seedSource;

    SunEntries(Provider p) {
        HashMap<String, String> attrs = new HashMap<String, String>(3);
        attrs.put("ThreadSafe", "true");
        if (NativePRNG.isAvailable()) {
            this.add(p, "SecureRandom", "NativePRNG", "sun.security.provider.NativePRNG", attrs);
        }
        if (NativePRNG.Blocking.isAvailable()) {
            this.add(p, "SecureRandom", "NativePRNGBlocking", "sun.security.provider.NativePRNG$Blocking", attrs);
        }
        if (NativePRNG.NonBlocking.isAvailable()) {
            this.add(p, "SecureRandom", "NativePRNGNonBlocking", "sun.security.provider.NativePRNG$NonBlocking", attrs);
        }
        attrs.put("ImplementedIn", "Software");
        this.add(p, "SecureRandom", "DRBG", "sun.security.provider.DRBG", attrs);
        this.add(p, "SecureRandom", "SHA1PRNG", "sun.security.provider.SecureRandom", attrs);
        attrs.clear();
        String dsaKeyClasses = "java.security.interfaces.DSAPublicKey|java.security.interfaces.DSAPrivateKey";
        attrs.put("SupportedKeyClasses", dsaKeyClasses);
        attrs.put("ImplementedIn", "Software");
        attrs.put("KeySize", "1024");
        this.addWithAlias(p, "Signature", "SHA1withDSA", "sun.security.provider.DSA$SHA1withDSA", attrs);
        this.addWithAlias(p, "Signature", "NONEwithDSA", "sun.security.provider.DSA$RawDSA", attrs);
        attrs.put("KeySize", "2048");
        this.addWithAlias(p, "Signature", "SHA224withDSA", "sun.security.provider.DSA$SHA224withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA256withDSA", "sun.security.provider.DSA$SHA256withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA3-224withDSA", "sun.security.provider.DSA$SHA3_224withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA3-256withDSA", "sun.security.provider.DSA$SHA3_256withDSA", attrs);
        attrs.put("KeySize", "3072");
        this.addWithAlias(p, "Signature", "SHA384withDSA", "sun.security.provider.DSA$SHA384withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA512withDSA", "sun.security.provider.DSA$SHA512withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA3-384withDSA", "sun.security.provider.DSA$SHA3_384withDSA", attrs);
        this.addWithAlias(p, "Signature", "SHA3-512withDSA", "sun.security.provider.DSA$SHA3_512withDSA", attrs);
        attrs.remove("KeySize");
        this.add(p, "Signature", "SHA1withDSAinP1363Format", "sun.security.provider.DSA$SHA1withDSAinP1363Format");
        this.add(p, "Signature", "NONEwithDSAinP1363Format", "sun.security.provider.DSA$RawDSAinP1363Format");
        this.add(p, "Signature", "SHA224withDSAinP1363Format", "sun.security.provider.DSA$SHA224withDSAinP1363Format");
        this.add(p, "Signature", "SHA256withDSAinP1363Format", "sun.security.provider.DSA$SHA256withDSAinP1363Format");
        this.add(p, "Signature", "SHA384withDSAinP1363Format", "sun.security.provider.DSA$SHA384withDSAinP1363Format");
        this.add(p, "Signature", "SHA512withDSAinP1363Format", "sun.security.provider.DSA$SHA512withDSAinP1363Format");
        this.add(p, "Signature", "SHA3-224withDSAinP1363Format", "sun.security.provider.DSA$SHA3_224withDSAinP1363Format");
        this.add(p, "Signature", "SHA3-256withDSAinP1363Format", "sun.security.provider.DSA$SHA3_256withDSAinP1363Format");
        this.add(p, "Signature", "SHA3-384withDSAinP1363Format", "sun.security.provider.DSA$SHA3_384withDSAinP1363Format");
        this.add(p, "Signature", "SHA3-512withDSAinP1363Format", "sun.security.provider.DSA$SHA3_512withDSAinP1363Format");
        attrs.clear();
        attrs.put("ImplementedIn", "Software");
        attrs.put("KeySize", "2048");
        String dsaKPGImplClass = "sun.security.provider.DSAKeyPairGenerator$";
        dsaKPGImplClass = dsaKPGImplClass + (useLegacyDSA ? "Legacy" : "Current");
        this.addWithAlias(p, "KeyPairGenerator", "DSA", dsaKPGImplClass, attrs);
        this.addWithAlias(p, "AlgorithmParameterGenerator", "DSA", "sun.security.provider.DSAParameterGenerator", attrs);
        attrs.remove("KeySize");
        this.addWithAlias(p, "AlgorithmParameters", "DSA", "sun.security.provider.DSAParameters", attrs);
        this.addWithAlias(p, "KeyFactory", "DSA", "sun.security.provider.DSAKeyFactory", attrs);
        this.add(p, "MessageDigest", "MD2", "sun.security.provider.MD2", attrs);
        this.add(p, "MessageDigest", "MD5", "sun.security.provider.MD5", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-1", "sun.security.provider.SHA", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-224", "sun.security.provider.SHA2$SHA224", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-256", "sun.security.provider.SHA2$SHA256", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-384", "sun.security.provider.SHA5$SHA384", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-512", "sun.security.provider.SHA5$SHA512", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-512/224", "sun.security.provider.SHA5$SHA512_224", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA-512/256", "sun.security.provider.SHA5$SHA512_256", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA3-224", "sun.security.provider.SHA3$SHA224", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA3-256", "sun.security.provider.SHA3$SHA256", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA3-384", "sun.security.provider.SHA3$SHA384", attrs);
        this.addWithAlias(p, "MessageDigest", "SHA3-512", "sun.security.provider.SHA3$SHA512", attrs);
        this.addWithAlias(p, "CertificateFactory", "X.509", "sun.security.provider.X509Factory", attrs);
        this.add(p, "KeyStore", "PKCS12", "sun.security.pkcs12.PKCS12KeyStore$DualFormatPKCS12");
        this.add(p, "KeyStore", "JKS", "sun.security.provider.JavaKeyStore$DualFormatJKS", attrs);
        this.add(p, "KeyStore", "CaseExactJKS", "sun.security.provider.JavaKeyStore$CaseExactJKS", attrs);
        this.add(p, "KeyStore", "DKS", "sun.security.provider.DomainKeyStore$DKS", attrs);
        this.add(p, "CertStore", "Collection", "sun.security.provider.certpath.CollectionCertStore", attrs);
        this.add(p, "CertStore", "com.sun.security.IndexedCollection", "sun.security.provider.certpath.IndexedCollectionCertStore", attrs);
        this.add(p, "Policy", "JavaPolicy", "sun.security.provider.PolicySpiFile");
        this.add(p, "Configuration", "JavaLoginConfig", "sun.security.provider.ConfigFile$Spi");
        attrs.clear();
        attrs.put("ValidationAlgorithm", "RFC5280");
        attrs.put("ImplementedIn", "Software");
        this.add(p, "CertPathBuilder", "PKIX", "sun.security.provider.certpath.SunCertPathBuilder", attrs);
        this.add(p, "CertPathValidator", "PKIX", "sun.security.provider.certpath.PKIXCertPathValidator", attrs);
    }

    Iterator<Provider.Service> iterator() {
        return this.services.iterator();
    }

    private void add(Provider p, String type, String algo, String cn) {
        this.services.add(new Provider.Service(p, type, algo, cn, null, null));
    }

    private void add(Provider p, String type, String algo, String cn, HashMap<String, String> attrs) {
        this.services.add(new Provider.Service(p, type, algo, cn, null, attrs));
    }

    private void addWithAlias(Provider p, String type, String algo, String cn, HashMap<String, String> attrs) {
        this.services.add(new Provider.Service(p, type, algo, cn, SecurityProviderConstants.getAliases(algo), attrs));
    }

    static String getSeedSource() {
        return seedSource;
    }

    static File getDeviceFile(URL device) throws IOException {
        try {
            URI deviceURI = device.toURI();
            if (deviceURI.isOpaque()) {
                URI localDir = new File(StaticProperty.userDir()).toURI();
                String uriPath = localDir.toString() + deviceURI.toString().substring(5);
                return new File(URI.create(uriPath));
            }
            return new File(deviceURI);
        }
        catch (URISyntaxException use) {
            return new File(device.getPath());
        }
    }

    static {
        useLegacyDSA = Boolean.parseBoolean(GetPropertyAction.privilegedGetProperty("jdk.security.legacyDSAKeyPairGenerator"));
        seedSource = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String egdSource = System.getProperty(SunEntries.PROP_EGD, "");
                if (egdSource.length() != 0) {
                    return egdSource;
                }
                egdSource = Security.getProperty(SunEntries.PROP_RNDSOURCE);
                if (egdSource == null) {
                    return "";
                }
                return egdSource;
            }
        });
        DEF_SECURE_RANDOM_ALGO = NativePRNG.isAvailable() && (seedSource.equals(URL_DEV_URANDOM) || seedSource.equals(URL_DEV_RANDOM)) ? "NativePRNG" : "DRBG";
    }
}

