/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import sun.security.util.Debug;
import sun.security.util.DerValue;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public final class OCSPNonceExtension
extends Extension {
    private static final String EXTENSION_NAME = "OCSPNonce";
    private byte[] nonceData = null;

    public OCSPNonceExtension(int length) throws IOException {
        this(false, length);
    }

    public OCSPNonceExtension(boolean isCritical, int length) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = isCritical;
        if (length <= 0 || length > 32) {
            throw new IllegalArgumentException("Length of nonce must be at least 1 byte and can be up to 32 bytes");
        }
        SecureRandom rng = new SecureRandom();
        this.nonceData = new byte[length];
        rng.nextBytes(this.nonceData);
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public OCSPNonceExtension(byte[] incomingNonce) throws IOException {
        this(false, incomingNonce);
    }

    public OCSPNonceExtension(boolean isCritical, byte[] incomingNonce) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = isCritical;
        Objects.requireNonNull(incomingNonce, "Nonce data must be non-null");
        if (incomingNonce.length <= 0 || incomingNonce.length > 32) {
            throw new IllegalArgumentException("Nonce data must be at least 1 byte and can be up to 32 bytes in length");
        }
        this.nonceData = (byte[])incomingNonce.clone();
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public byte[] getNonceValue() {
        return (byte[])this.nonceData.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(EXTENSION_NAME).append(": ");
        sb.append(this.nonceData == null ? "" : Debug.toString(this.nonceData));
        sb.append("\n");
        return sb.toString();
    }

    public String getName() {
        return EXTENSION_NAME;
    }
}

