/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath.ssl;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public final class SSLServerCertStore
extends CertStoreSpi {
    private final URI uri;
    private static final GetChainTrustManager trustManager;
    private static final SSLSocketFactory socketFactory;
    private static final HostnameVerifier hostnameVerifier;

    SSLServerCertStore(URI uri) throws InvalidAlgorithmParameterException {
        super(null);
        this.uri = uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<X509Certificate> engineGetCertificates(CertSelector selector) throws CertStoreException {
        try {
            URLConnection urlConn = this.uri.toURL().openConnection();
            if (!(urlConn instanceof HttpsURLConnection)) return Collections.emptySet();
            if (socketFactory == null) {
                throw new CertStoreException("No initialized SSLSocketFactory");
            }
            HttpsURLConnection https = (HttpsURLConnection)urlConn;
            https.setSSLSocketFactory(socketFactory);
            https.setHostnameVerifier(hostnameVerifier);
            GetChainTrustManager getChainTrustManager = trustManager;
            synchronized (getChainTrustManager) {
                try {
                    https.connect();
                    List<X509Certificate> list = SSLServerCertStore.getMatchingCerts(SSLServerCertStore.trustManager.serverChain, selector);
                    return list;
                }
                catch (IOException ioe) {
                    if (!SSLServerCertStore.trustManager.exchangedServerCerts) throw ioe;
                    List<X509Certificate> list2 = SSLServerCertStore.getMatchingCerts(SSLServerCertStore.trustManager.serverChain, selector);
                    return list2;
                }
                finally {
                    trustManager.cleanup();
                }
            }
        }
        catch (IOException ioe2) {
            throw new CertStoreException(ioe2);
        }
    }

    private static List<X509Certificate> getMatchingCerts(List<X509Certificate> certs, CertSelector selector) {
        if (selector == null) {
            return certs;
        }
        ArrayList<X509Certificate> matchedCerts = new ArrayList<X509Certificate>(certs.size());
        for (X509Certificate cert : certs) {
            if (!selector.match(cert)) continue;
            matchedCerts.add(cert);
        }
        return matchedCerts;
    }

    public Collection<X509CRL> engineGetCRLs(CRLSelector selector) throws CertStoreException {
        throw new UnsupportedOperationException();
    }

    public static CertStore getInstance(URI uri) throws InvalidAlgorithmParameterException {
        return new CS(new SSLServerCertStore(uri), null, "SSLServer", null);
    }

    static {
        SSLSocketFactory tempFactory;
        trustManager = new GetChainTrustManager();
        hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{trustManager}, null);
            tempFactory = context.getSocketFactory();
        }
        catch (GeneralSecurityException gse) {
            tempFactory = null;
        }
        socketFactory = tempFactory;
    }

    private static class GetChainTrustManager
    extends X509ExtendedTrustManager {
        private List<X509Certificate> serverChain = Collections.emptyList();
        private boolean exchangedServerCerts = false;

        private GetChainTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.exchangedServerCerts = true;
            this.serverChain = chain == null ? Collections.emptyList() : Arrays.asList(chain);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.checkServerTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.checkServerTrusted(chain, authType);
        }

        void cleanup() {
            this.exchangedServerCerts = false;
            this.serverChain = Collections.emptyList();
        }
    }

    private static class CS
    extends CertStore {
        protected CS(CertStoreSpi spi, Provider p, String type, CertStoreParameters params) {
            super(spi, p, type, params);
        }
    }
}

