/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.SecurityProviderConstants;

public abstract class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger SQRT_2048 = BigInteger.TWO.pow(2047).sqrt();
    private static final BigInteger SQRT_3072 = BigInteger.TWO.pow(3071).sqrt();
    private static final BigInteger SQRT_4096 = BigInteger.TWO.pow(4095).sqrt();
    private BigInteger publicExponent;
    private int keySize;
    private final RSAUtil.KeyType type;
    private AlgorithmParameterSpec keyParams;
    private SecureRandom random;
    private boolean useNew;

    RSAKeyPairGenerator(RSAUtil.KeyType type, int defKeySize) {
        this.type = type;
        this.initialize(defKeySize, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        try {
            this.initialize(new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4), random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException(iape.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        boolean useNew;
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)params;
        int tmpKeySize = rsaSpec.getKeysize();
        BigInteger tmpPubExp = rsaSpec.getPublicExponent();
        AlgorithmParameterSpec tmpParams = rsaSpec.getKeyParams();
        boolean bl = useNew = tmpKeySize >= 2048 && (tmpKeySize & 1) == 0;
        if (tmpPubExp == null) {
            tmpPubExp = RSAKeyGenParameterSpec.F4;
        } else {
            if (!tmpPubExp.testBit(0)) {
                throw new InvalidAlgorithmParameterException("Public exponent must be an odd number");
            }
            BigInteger minValue = RSAKeyGenParameterSpec.F0;
            int maxBitLength = tmpKeySize;
            if (tmpPubExp.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be " + minValue + " or larger");
            }
            if (tmpPubExp.bitLength() > maxBitLength) {
                throw new InvalidAlgorithmParameterException("Public exponent must be no longer than " + maxBitLength + " bits");
            }
            useNew &= tmpPubExp.compareTo(RSAKeyGenParameterSpec.F4) >= 0 && tmpPubExp.bitLength() < 256;
        }
        try {
            RSAKeyFactory.checkKeyLengths(tmpKeySize, tmpPubExp, 512, 65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        try {
            this.keyParams = RSAUtil.checkParamsAgainstType(this.type, tmpParams);
        }
        catch (ProviderException e) {
            throw new InvalidAlgorithmParameterException("Invalid key parameters", e);
        }
        this.keySize = tmpKeySize;
        this.publicExponent = tmpPubExp;
        this.random = random == null ? JCAUtil.getSecureRandom() : random;
        this.useNew = useNew;
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair kp;
        BigInteger q;
        BigInteger p;
        BigInteger n;
        BigInteger e = this.publicExponent;
        BigInteger minValue = this.useNew ? RSAKeyPairGenerator.getSqrt(this.keySize) : BigInteger.ZERO;
        int lp = this.keySize + 1 >> 1;
        int lq = this.keySize - lp;
        int pqDiffSize = lp - 100;
        do {
            p = null;
            q = null;
            int i = 0;
            while (i++ < 10 * lp) {
                BigInteger tmpP = BigInteger.probablePrime(lp, this.random);
                if (this.useNew && tmpP.compareTo(minValue) != 1 || !RSAKeyPairGenerator.isRelativePrime(e, tmpP.subtract(BigInteger.ONE))) continue;
                p = tmpP;
                break;
            }
            if (p == null) {
                throw new ProviderException("Cannot find prime P");
            }
            i = 0;
            while (i++ < 20 * lq) {
                BigInteger tmpQ = BigInteger.probablePrime(lq, this.random);
                if (this.useNew && tmpQ.compareTo(minValue) != 1 || p.subtract(tmpQ).abs().compareTo(BigInteger.TWO.pow(pqDiffSize)) != 1 || !RSAKeyPairGenerator.isRelativePrime(e, tmpQ.subtract(BigInteger.ONE))) continue;
                q = tmpQ;
                break;
            }
            if (q != null) continue;
            throw new ProviderException("Cannot find prime Q");
        } while ((n = p.multiply(q)).bitLength() != this.keySize || (kp = RSAKeyPairGenerator.createKeyPair(this.type, this.keyParams, n, e, p, q)) == null);
        return kp;
    }

    private static BigInteger getSqrt(int keySize) {
        BigInteger sqrt = null;
        switch (keySize) {
            case 2048: {
                sqrt = SQRT_2048;
                break;
            }
            case 3072: {
                sqrt = SQRT_3072;
                break;
            }
            case 4096: {
                sqrt = SQRT_4096;
                break;
            }
            default: {
                sqrt = BigInteger.TWO.pow(keySize - 1).sqrt();
            }
        }
        return sqrt;
    }

    private static boolean isRelativePrime(BigInteger e, BigInteger bi) {
        if (e.compareTo(RSAKeyGenParameterSpec.F4) == 0 || e.compareTo(RSAKeyGenParameterSpec.F0) == 0) {
            return !bi.mod(e).equals(BigInteger.ZERO);
        }
        return e.gcd(bi).equals(BigInteger.ONE);
    }

    private static KeyPair createKeyPair(RSAUtil.KeyType type, AlgorithmParameterSpec keyParams, BigInteger n, BigInteger e, BigInteger p, BigInteger q) {
        BigInteger p1 = p.subtract(BigInteger.ONE);
        BigInteger q1 = q.subtract(BigInteger.ONE);
        BigInteger phi = p1.multiply(q1);
        BigInteger gcd = p1.gcd(q1);
        BigInteger lcm = gcd.equals(BigInteger.ONE) ? phi : phi.divide(gcd);
        BigInteger d = e.modInverse(lcm);
        if (d.compareTo(BigInteger.TWO.pow(p.bitLength())) != 1) {
            return null;
        }
        BigInteger pe = d.mod(p1);
        BigInteger qe = d.mod(q1);
        BigInteger coeff = q.modInverse(p);
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(type, keyParams, n, e);
            RSAPrivateCrtKeyImpl privateKey = new RSAPrivateCrtKeyImpl(type, keyParams, n, e, d, p, q, pe, qe, coeff);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static final class PSS
    extends RSAKeyPairGenerator {
        public PSS() {
            super(RSAUtil.KeyType.PSS, SecurityProviderConstants.DEF_RSASSA_PSS_KEY_SIZE);
        }
    }

    public static final class Legacy
    extends RSAKeyPairGenerator {
        public Legacy() {
            super(RSAUtil.KeyType.RSA, SecurityProviderConstants.DEF_RSA_KEY_SIZE);
        }
    }
}

