/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.NamedGroup;
import sun.security.ssl.NamedGroupCredentials;
import sun.security.ssl.NamedGroupPossession;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;
import sun.security.util.HexDumpEncoder;

final class ECDHClientKeyExchange {
    static final SSLConsumer ecdhHandshakeConsumer = new ECDHClientKeyExchangeConsumer();
    static final HandshakeProducer ecdhHandshakeProducer = new ECDHClientKeyExchangeProducer();
    static final SSLConsumer ecdheHandshakeConsumer = new ECDHEClientKeyExchangeConsumer();
    static final HandshakeProducer ecdheHandshakeProducer = new ECDHEClientKeyExchangeProducer();

    ECDHClientKeyExchange() {
    }

    private static final class ECDHClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)possession;
                break;
            }
            if (x509Possession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected EC server cert for ECDH client key exchange");
            }
            NamedGroup namedGroup = null;
            ECParameterSpec ecParams = x509Possession.getECParameterSpec();
            NamedParameterSpec namedParams = null;
            if (ecParams != null) {
                namedGroup = NamedGroup.valueOf(ecParams);
            }
            if (ecParams == null) {
                namedParams = x509Possession.getXECParameterSpec();
                namedGroup = NamedGroup.nameOf(namedParams.getName());
            }
            if (ecParams == null && namedParams == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC/XDH server cert for ECDH client key exchange");
            }
            if (namedGroup == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group in server cert for ECDH client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDH ClientKeyExchange handshake message", cke);
            }
            try {
                SSLCredentials sslCredentials = namedGroup.decodeCredentials(cke.encodedPoint);
                if (shc.algorithmConstraints != null && sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)sslCredentials;
                    if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        shc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ClientKeyExchange for " + (Object)((Object)namedGroup) + " does not comply with algorithm constraints");
                    }
                }
                shc.handshakeCredentials.add(sslCredentials);
            }
            catch (GeneralSecurityException e) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode ECDH PublicKey: " + (Object)((Object)namedGroup));
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class ECDHClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials credential : chc.handshakeCredentials) {
                if (!(credential instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)credential;
                break;
            }
            if (x509Credentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No server certificate for ECDH client key exchange");
            }
            PublicKey publicKey = x509Credentials.popPublicKey;
            NamedGroup namedGroup = null;
            String algorithm = publicKey.getAlgorithm();
            if (algorithm.equals("EC")) {
                params = ((ECPublicKey)publicKey).getParams();
                namedGroup = NamedGroup.valueOf(params);
            } else if (algorithm.equals("XDH")) {
                params = ((XECPublicKey)publicKey).getParams();
                if (params instanceof NamedParameterSpec) {
                    String name = ((NamedParameterSpec)params).getName();
                    namedGroup = NamedGroup.nameOf(name);
                }
            } else {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC/XDH server certificate for ECDH client key exchange");
            }
            if (namedGroup == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC/XDH server cert for ECDH client key exchange");
            }
            SSLPossession sslPossession = namedGroup.createPossession(chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sslPossession);
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)chc, sslPossession.encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDH ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class ECDHEClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHEClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            NamedGroupPossession sslPossession = null;
            NamedGroup namedGroup = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof NamedGroupPossession)) continue;
                NamedGroupPossession poss = (NamedGroupPossession)possession;
                namedGroup = poss.getNamedGroup();
                sslPossession = poss;
                break;
            }
            if (sslPossession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected ECDHE possessions for client key exchange");
            }
            if (namedGroup == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDHE client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDHE ClientKeyExchange handshake message", cke);
            }
            try {
                SSLCredentials sslCredentials = namedGroup.decodeCredentials(cke.encodedPoint);
                if (shc.algorithmConstraints != null && sslCredentials instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)sslCredentials;
                    if (!shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        shc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ClientKeyExchange for " + (Object)((Object)namedGroup) + " does not comply with algorithm constraints");
                    }
                }
                shc.handshakeCredentials.add(sslCredentials);
            }
            catch (GeneralSecurityException e) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + (Object)((Object)namedGroup));
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class ECDHEClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHEClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SSLCredentials sslCredentials = null;
            NamedGroup ng = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof NamedGroupCredentials)) continue;
                NamedGroupCredentials creds = (NamedGroupCredentials)cd;
                ng = creds.getNamedGroup();
                sslCredentials = cd;
                break;
            }
            if (sslCredentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No ECDHE credentials negotiated for client key exchange");
            }
            SSLPossession sslPossession = ng.createPossession(chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sslPossession);
            ECDHClientKeyExchangeMessage cke = new ECDHClientKeyExchangeMessage((HandshakeContext)chc, sslPossession.encode());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDHE ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class ECDHClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] encodedPoint;

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, byte[] encodedPublicKey) {
            super(handshakeContext);
            this.encodedPoint = encodedPublicKey;
        }

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            this.encodedPoint = m.remaining() != 0 ? Record.getBytes8(m) : new byte[0];
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                hos.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ECDH ClientKeyExchange\": '{'\n  \"ecdh public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] messageFields = new Object[]{"    <implicit>"};
                return messageFormat.format(messageFields);
            }
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

