/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.NamedGroup;
import sun.security.ssl.NamedGroupCredentials;
import sun.security.ssl.NamedGroupPossession;
import sun.security.ssl.RSASignature;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;
import sun.security.util.HexDumpEncoder;

final class ECDHServerKeyExchange {
    static final SSLConsumer ecdheHandshakeConsumer = new ECDHServerKeyExchangeConsumer();
    static final HandshakeProducer ecdheHandshakeProducer = new ECDHServerKeyExchangeProducer();

    ECDHServerKeyExchange() {
    }

    private static final class ECDHServerKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            ECDHServerKeyExchangeMessage skem = new ECDHServerKeyExchangeMessage(chc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDH ServerKeyExchange handshake message", skem);
            }
            chc.handshakeCredentials.add(skem.sslCredentials);
        }
    }

    private static final class ECDHServerKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            ECDHServerKeyExchangeMessage skem = new ECDHServerKeyExchangeMessage(shc);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDH ServerKeyExchange handshake message", skem);
            }
            skem.write(shc.handshakeOutput);
            shc.handshakeOutput.flush();
            return null;
        }
    }

    private static final class ECDHServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final NamedGroup namedGroup;
        private final byte[] publicPoint;
        private final byte[] paramsSignature;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;
        private SSLCredentials sslCredentials;

        ECDHServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            ServerHandshakeContext shc = (ServerHandshakeContext)handshakeContext;
            NamedGroupPossession namedGroupPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (possession instanceof NamedGroupPossession) {
                    namedGroupPossession = (NamedGroupPossession)possession;
                    if (x509Possession == null) continue;
                    break;
                }
                if (!(possession instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)possession;
                if (namedGroupPossession == null) continue;
                break;
            }
            if (namedGroupPossession == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No ECDHE credentials negotiated for server key exchange");
            }
            this.namedGroup = namedGroupPossession.getNamedGroup();
            if (this.namedGroup == null || !this.namedGroup.isAvailable) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing or improper named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = this.namedGroup.encodePossessionPublicKey(namedGroupPossession);
            if (this.publicPoint == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Missing public point for named group: " + (Object)((Object)this.namedGroup));
            }
            if (x509Possession == null) {
                this.paramsSignature = null;
                this.signatureScheme = null;
                this.useExplicitSigAlgorithm = false;
            } else {
                byte[] signature;
                Signature signer;
                this.useExplicitSigAlgorithm = shc.negotiatedProtocol.useTLS12PlusSpec();
                if (this.useExplicitSigAlgorithm) {
                    Map.Entry<SignatureScheme, Signature> schemeAndSigner = SignatureScheme.getSignerOfPreferableAlgorithm(shc.algorithmConstraints, shc.peerRequestedSignatureSchemes, x509Possession, shc.negotiatedProtocol);
                    if (schemeAndSigner == null) {
                        throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
                    }
                    this.signatureScheme = schemeAndSigner.getKey();
                    signer = schemeAndSigner.getValue();
                } else {
                    this.signatureScheme = null;
                    try {
                        signer = ECDHServerKeyExchangeMessage.getSignature(x509Possession.popPrivateKey.getAlgorithm(), x509Possession.popPrivateKey);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Possession.popPrivateKey.getAlgorithm(), e);
                    }
                }
                try {
                    ECDHServerKeyExchangeMessage.updateSignature(signer, shc.clientHelloRandom.randomBytes, shc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                    signature = signer.sign();
                }
                catch (SignatureException ex) {
                    throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign ecdhe parameters: " + x509Possession.popPrivateKey.getAlgorithm(), ex);
                }
                this.paramsSignature = signature;
            }
        }

        ECDHServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Signature signer;
            ClientHandshakeContext chc = (ClientHandshakeContext)handshakeContext;
            byte curveType = (byte)Record.getInt8(m);
            if (curveType != 3) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported ECCurveType: " + curveType);
            }
            int namedGroupId = Record.getInt16(m);
            this.namedGroup = NamedGroup.valueOf(namedGroupId);
            if (this.namedGroup == null) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unknown named group ID: " + namedGroupId);
            }
            if (!SupportedGroupsExtension.SupportedGroups.isSupported(this.namedGroup)) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported named group: " + (Object)((Object)this.namedGroup));
            }
            this.publicPoint = Record.getBytes8(m);
            if (this.publicPoint.length == 0) {
                throw chc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Insufficient Point data: " + (Object)((Object)this.namedGroup));
            }
            try {
                Object object2;
                this.sslCredentials = this.namedGroup.decodeCredentials(this.publicPoint);
                if (handshakeContext.algorithmConstraints != null && (object2 = this.sslCredentials) instanceof NamedGroupCredentials) {
                    NamedGroupCredentials namedGroupCredentials = (NamedGroupCredentials)object2;
                    if (!handshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroupCredentials.getPublicKey())) {
                        chc.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "ServerKeyExchange for " + (Object)((Object)this.namedGroup) + " does not comply with algorithm constraints");
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Cannot decode named group: " + NamedGroup.nameOf(namedGroupId));
            }
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)cd;
                break;
            }
            if (x509Credentials == null) {
                if (m.hasRemaining()) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = chc.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int ssid = Record.getInt16(m);
                this.signatureScheme = SignatureScheme.valueOf(ssid);
                if (this.signatureScheme == null) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + ssid + ") used in ECDH ServerKeyExchange handshake message");
                }
                if (!chc.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in ECDH ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(m);
            if (this.useExplicitSigAlgorithm) {
                try {
                    signer = this.signatureScheme.getVerifier(x509Credentials.popPublicKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException nsae) {
                    throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + this.signatureScheme.name, nsae);
                }
            }
            try {
                signer = ECDHServerKeyExchangeMessage.getSignature(x509Credentials.popPublicKey.getAlgorithm(), x509Credentials.popPublicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Credentials.popPublicKey.getAlgorithm(), e);
            }
            try {
                ECDHServerKeyExchangeMessage.updateSignature(signer, chc.clientHelloRandom.randomBytes, chc.serverHelloRandom.randomBytes, this.namedGroup.id, this.publicPoint);
                if (!signer.verify(this.paramsSignature)) {
                    throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid ECDH ServerKeyExchange signature");
                }
            }
            catch (SignatureException ex) {
                throw chc.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify ECDH ServerKeyExchange signature", ex);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int sigLen = 0;
            if (this.paramsSignature != null) {
                sigLen = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    sigLen += SignatureScheme.sizeInRecord();
                }
            }
            return 4 + this.publicPoint.length + sigLen;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(this.namedGroup.id);
            hos.putBytes8(this.publicPoint);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    hos.putInt16(this.signatureScheme.id);
                }
                hos.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{2}\"\n    \"signature\": '{'\n{3}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      "), this.signatureScheme.name, Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(messageFields);
            }
            if (this.paramsSignature != null) {
                MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}',\n  \"signature\": '{'\n{2}\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexEncoder = new HexDumpEncoder();
                Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      "), Utilities.indent(hexEncoder.encodeBuffer(this.paramsSignature), "    ")};
                return messageFormat.format(messageFields);
            }
            MessageFormat messageFormat = new MessageFormat("\"ECDH ServerKeyExchange\": '{'\n  \"parameters\":  '{'\n    \"named group\": \"{0}\"\n    \"ecdh public\": '{'\n{1}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{this.namedGroup.name, Utilities.indent(hexEncoder.encodeBuffer(this.publicPoint), "      ")};
            return messageFormat.format(messageFields);
        }

        private static Signature getSignature(String keyAlgorithm, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signer = switch (keyAlgorithm) {
                case "EC" -> Signature.getInstance("SHA1withECDSA");
                case "EdDSA" -> Signature.getInstance("EdDSA");
                case "RSA" -> RSASignature.getInstance();
                default -> throw new NoSuchAlgorithmException("neither an RSA or a EC key : " + keyAlgorithm);
            };
            if (signer != null) {
                if (key instanceof PublicKey) {
                    signer.initVerify((PublicKey)key);
                } else {
                    signer.initSign((PrivateKey)key);
                }
            }
            return signer;
        }

        private static void updateSignature(Signature sig, byte[] clntNonce, byte[] svrNonce, int namedGroupId, byte[] publicPoint) throws SignatureException {
            sig.update(clntNonce);
            sig.update(svrNonce);
            sig.update((byte)3);
            sig.update((byte)(namedGroupId >> 8 & 0xFF));
            sig.update((byte)(namedGroupId & 0xFF));
            sig.update((byte)publicPoint.length);
            sig.update(publicPoint);
        }
    }
}

