/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.X509TrustManagerImpl;
import sun.security.util.KnownOIDs;

final class X509KeyManagerImpl
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static Date verificationDate;
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    X509KeyManagerImpl(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    X509KeyManagerImpl(List<KeyStore.Builder> builders) {
        this.builders = builders;
        this.uidCounter = new AtomicLong();
        this.entryCacheMap = Collections.synchronizedMap(new SizedMap());
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        return entry == null ? null : (X509Certificate[])entry.getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getEntry(alias);
        return entry == null ? null : entry.getPrivateKey();
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyTypes), issuers, CheckType.CLIENT, this.getAlgorithmConstraints(socket));
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyTypes), issuers, CheckType.CLIENT, this.getAlgorithmConstraints(engine));
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyType), issuers, CheckType.SERVER, this.getAlgorithmConstraints(socket), X509TrustManagerImpl.getRequestedServerNames(socket), "HTTPS");
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(keyType), issuers, CheckType.SERVER, this.getAlgorithmConstraints(engine), X509TrustManagerImpl.getRequestedServerNames(engine), "HTTPS");
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers, CheckType.CLIENT, null);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(keyType, issuers, CheckType.SERVER, null);
    }

    private AlgorithmConstraints getAlgorithmConstraints(Socket socket) {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session != null && ProtocolVersion.useTLS12PlusSpec(session.getProtocol())) {
                String[] peerSupportedSignAlgs = null;
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    peerSupportedSignAlgs = extSession.getPeerSupportedSignatureAlgorithms();
                }
                return new SSLAlgorithmConstraints(sslSocket, peerSupportedSignAlgs, true);
            }
            return new SSLAlgorithmConstraints(sslSocket, true);
        }
        return new SSLAlgorithmConstraints((SSLSocket)null, true);
    }

    private AlgorithmConstraints getAlgorithmConstraints(SSLEngine engine) {
        SSLSession session;
        if (engine != null && (session = engine.getHandshakeSession()) != null && ProtocolVersion.useTLS12PlusSpec(session.getProtocol())) {
            String[] peerSupportedSignAlgs = null;
            if (session instanceof ExtendedSSLSession) {
                ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                peerSupportedSignAlgs = extSession.getPeerSupportedSignatureAlgorithms();
            }
            return new SSLAlgorithmConstraints(engine, peerSupportedSignAlgs, true);
        }
        return new SSLAlgorithmConstraints(engine, true);
    }

    private String makeAlias(EntryStatus entry) {
        return this.uidCounter.incrementAndGet() + "." + entry.builderIndex + "." + entry.alias;
    }

    private KeyStore.PrivateKeyEntry getEntry(String alias) {
        KeyStore.PrivateKeyEntry entry;
        if (alias == null) {
            return null;
        }
        Reference<KeyStore.PrivateKeyEntry> ref = this.entryCacheMap.get(alias);
        KeyStore.PrivateKeyEntry privateKeyEntry = entry = ref != null ? ref.get() : null;
        if (entry != null) {
            return entry;
        }
        int firstDot = alias.indexOf(46);
        int secondDot = alias.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == firstDot) {
            return null;
        }
        try {
            int builderIndex = Integer.parseInt(alias.substring(firstDot + 1, secondDot));
            String keyStoreAlias = alias.substring(secondDot + 1);
            KeyStore.Builder builder = this.builders.get(builderIndex);
            KeyStore ks = builder.getKeyStore();
            KeyStore.Entry newEntry = ks.getEntry(keyStoreAlias, builder.getProtectionParameter(keyStoreAlias));
            if (!(newEntry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            entry = (KeyStore.PrivateKeyEntry)newEntry;
            this.entryCacheMap.put(alias, new SoftReference<KeyStore.PrivateKeyEntry>(entry));
            return entry;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<KeyType> getKeyTypes(String ... keyTypes) {
        if (keyTypes == null || keyTypes.length == 0 || keyTypes[0] == null) {
            return null;
        }
        ArrayList<KeyType> list = new ArrayList<KeyType>(keyTypes.length);
        for (String keyType : keyTypes) {
            list.add(new KeyType(keyType));
        }
        return list;
    }

    private String chooseAlias(List<KeyType> keyTypeList, Principal[] issuers, CheckType checkType, AlgorithmConstraints constraints) {
        return this.chooseAlias(keyTypeList, issuers, checkType, constraints, null, null);
    }

    private String chooseAlias(List<KeyType> keyTypeList, Principal[] issuers, CheckType checkType, AlgorithmConstraints constraints, List<SNIServerName> requestedServerNames, String idAlgorithm) {
        if (keyTypeList == null || keyTypeList.isEmpty()) {
            return null;
        }
        Set<Principal> issuerSet = this.getIssuerSet(issuers);
        ArrayList<EntryStatus> allResults = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> results = this.getAliases(i, keyTypeList, issuerSet, false, checkType, constraints, requestedServerNames, idAlgorithm);
                if (results == null) continue;
                EntryStatus status = results.get(0);
                if (status.checkResult == CheckResult.OK) {
                    if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                        SSLLogger.fine("KeyMgr: choosing key: " + status, new Object[0]);
                    }
                    return this.makeAlias(status);
                }
                if (allResults == null) {
                    allResults = new ArrayList<EntryStatus>();
                }
                allResults.addAll(results);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (allResults == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                SSLLogger.fine("KeyMgr: no matching key found", new Object[0]);
            }
            return null;
        }
        Collections.sort(allResults);
        if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
            SSLLogger.fine("KeyMgr: no good matching key found, returning best match out of", allResults);
        }
        return this.makeAlias((EntryStatus)allResults.get(0));
    }

    public String[] getAliases(String keyType, Principal[] issuers, CheckType checkType, AlgorithmConstraints constraints) {
        if (keyType == null) {
            return null;
        }
        Set<Principal> issuerSet = this.getIssuerSet(issuers);
        List<KeyType> keyTypeList = X509KeyManagerImpl.getKeyTypes(keyType);
        ArrayList<EntryStatus> allResults = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> results = this.getAliases(i, keyTypeList, issuerSet, true, checkType, constraints, null, null);
                if (results == null) continue;
                if (allResults == null) {
                    allResults = new ArrayList<EntryStatus>();
                }
                allResults.addAll(results);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (allResults == null || allResults.isEmpty()) {
            if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                SSLLogger.fine("KeyMgr: no matching alias found", new Object[0]);
            }
            return null;
        }
        Collections.sort(allResults);
        if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
            SSLLogger.fine("KeyMgr: getting aliases", allResults);
        }
        return this.toAliases((List<EntryStatus>)allResults);
    }

    private String[] toAliases(List<EntryStatus> results) {
        String[] s = new String[results.size()];
        int i = 0;
        for (EntryStatus result : results) {
            s[i++] = this.makeAlias(result);
        }
        return s;
    }

    private Set<Principal> getIssuerSet(Principal[] issuers) {
        if (issuers != null && issuers.length != 0) {
            return new HashSet<Principal>(Arrays.asList(issuers));
        }
        return null;
    }

    private List<EntryStatus> getAliases(int builderIndex, List<KeyType> keyTypes, Set<Principal> issuerSet, boolean findAll, CheckType checkType, AlgorithmConstraints constraints, List<SNIServerName> requestedServerNames, String idAlgorithm) throws Exception {
        KeyStore.Builder builder = this.builders.get(builderIndex);
        KeyStore ks = builder.getKeyStore();
        ArrayList<EntryStatus> results = null;
        Date date = verificationDate;
        boolean preferred = false;
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            Certificate[] chain;
            String alias = e.nextElement();
            if (!ks.isKeyEntry(alias) || (chain = ks.getCertificateChain(alias)) == null || chain.length == 0) continue;
            boolean incompatible = false;
            for (Certificate certificate : chain) {
                if (certificate instanceof X509Certificate) continue;
                incompatible = true;
                break;
            }
            if (incompatible) continue;
            int keyIndex = -1;
            int j = 0;
            for (KeyType keyType : keyTypes) {
                if (keyType.matches(chain)) {
                    keyIndex = j;
                    break;
                }
                ++j;
            }
            if (keyIndex == -1) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("keymanager")) continue;
                SSLLogger.fine("Ignore alias " + alias + ": key algorithm does not match", new Object[0]);
                continue;
            }
            if (issuerSet != null) {
                boolean found = false;
                for (Certificate cert : chain) {
                    X509Certificate xcert = (X509Certificate)cert;
                    if (!issuerSet.contains(xcert.getIssuerX500Principal())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("keymanager")) continue;
                    SSLLogger.fine("Ignore alias " + alias + ": issuers do not match", new Object[0]);
                    continue;
                }
            }
            if (constraints != null && !X509KeyManagerImpl.conformsToAlgorithmConstraints(constraints, chain, checkType.getValidator())) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("keymanager")) continue;
                SSLLogger.fine("Ignore alias " + alias + ": certificate list does not conform to algorithm constraints", new Object[0]);
                continue;
            }
            if (date == null) {
                date = new Date();
            }
            CheckResult checkResult = checkType.check((X509Certificate)chain[0], date, requestedServerNames, idAlgorithm);
            EntryStatus entryStatus = new EntryStatus(builderIndex, keyIndex, alias, chain, checkResult);
            if (!preferred && checkResult == CheckResult.OK && keyIndex == 0) {
                preferred = true;
            }
            if (preferred && !findAll) {
                return Collections.singletonList(entryStatus);
            }
            if (results == null) {
                results = new ArrayList<EntryStatus>();
            }
            results.add(entryStatus);
        }
        return results;
    }

    private static boolean conformsToAlgorithmConstraints(AlgorithmConstraints constraints, Certificate[] chain, String variant) {
        AlgorithmChecker checker = new AlgorithmChecker(constraints, variant);
        try {
            checker.init(false);
        }
        catch (CertPathValidatorException cpve) {
            if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                SSLLogger.fine("Cannot initialize algorithm constraints checker", cpve);
            }
            return false;
        }
        for (int i = chain.length - 1; i >= 0; --i) {
            Certificate cert = chain[i];
            try {
                checker.check(cert, Collections.emptySet());
                continue;
            }
            catch (CertPathValidatorException cpve) {
                if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                    SSLLogger.fine("Certificate does not conform to algorithm constraints", cert, cpve);
                }
                return false;
            }
        }
        return true;
    }

    private static class SizedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -8211222668790986062L;

        private SizedMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 10;
        }
    }

    private static enum CheckType {
        NONE(Collections.emptySet()),
        CLIENT(new HashSet<String>(List.of(KnownOIDs.anyExtendedKeyUsage.value(), KnownOIDs.clientAuth.value()))),
        SERVER(new HashSet<String>(List.of(KnownOIDs.anyExtendedKeyUsage.value(), KnownOIDs.serverAuth.value(), KnownOIDs.NETSCAPE_ExportApproved.value(), KnownOIDs.MICROSOFT_ExportApproved.value())));

        final Set<String> validEku;

        private CheckType(Set<String> validEku) {
            this.validEku = validEku;
        }

        private static boolean getBit(boolean[] keyUsage, int bit) {
            return bit < keyUsage.length && keyUsage[bit];
        }

        CheckResult check(X509Certificate cert, Date date, List<SNIServerName> serverNames, String idAlgorithm) {
            if (this == NONE) {
                return CheckResult.OK;
            }
            try {
                List<String> certEku = cert.getExtendedKeyUsage();
                if (certEku != null && Collections.disjoint(this.validEku, certEku)) {
                    return CheckResult.EXTENSION_MISMATCH;
                }
                boolean[] ku = cert.getKeyUsage();
                if (ku != null) {
                    String algorithm = cert.getPublicKey().getAlgorithm();
                    boolean supportsDigitalSignature = CheckType.getBit(ku, 0);
                    switch (algorithm) {
                        case "RSA": {
                            if (supportsDigitalSignature || this != CLIENT && CheckType.getBit(ku, 2)) break;
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        case "RSASSA-PSS": {
                            if (supportsDigitalSignature || this != SERVER) break;
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        case "DSA": {
                            if (supportsDigitalSignature) break;
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        case "DH": {
                            if (CheckType.getBit(ku, 4)) break;
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        case "EC": {
                            if (!supportsDigitalSignature) {
                                return CheckResult.EXTENSION_MISMATCH;
                            }
                            if (this != SERVER || CheckType.getBit(ku, 4)) break;
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    }
                }
            }
            catch (CertificateException e) {
                return CheckResult.EXTENSION_MISMATCH;
            }
            try {
                cert.checkValidity(date);
            }
            catch (CertificateException e) {
                return CheckResult.EXPIRED;
            }
            if (serverNames != null && !serverNames.isEmpty()) {
                for (SNIServerName serverName : serverNames) {
                    if (serverName.getType() != 0) continue;
                    if (!(serverName instanceof SNIHostName)) {
                        try {
                            serverName = new SNIHostName(serverName.getEncoded());
                        }
                        catch (IllegalArgumentException iae) {
                            if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                                SSLLogger.fine("Illegal server name: " + serverName, new Object[0]);
                            }
                            return CheckResult.INSENSITIVE;
                        }
                    }
                    String hostname = ((SNIHostName)serverName).getAsciiName();
                    try {
                        X509TrustManagerImpl.checkIdentity(hostname, cert, idAlgorithm);
                        break;
                    }
                    catch (CertificateException e) {
                        if (SSLLogger.isOn && SSLLogger.isOn("keymanager")) {
                            SSLLogger.fine("Certificate identity does not match Server Name Inidication (SNI): " + hostname, new Object[0]);
                        }
                        return CheckResult.INSENSITIVE;
                    }
                }
            }
            return CheckResult.OK;
        }

        public String getValidator() {
            if (this == CLIENT) {
                return "tls client";
            }
            if (this == SERVER) {
                return "tls server";
            }
            return "generic";
        }
    }

    private static class EntryStatus
    implements Comparable<EntryStatus> {
        final int builderIndex;
        final int keyIndex;
        final String alias;
        final CheckResult checkResult;

        EntryStatus(int builderIndex, int keyIndex, String alias, Certificate[] chain, CheckResult checkResult) {
            this.builderIndex = builderIndex;
            this.keyIndex = keyIndex;
            this.alias = alias;
            this.checkResult = checkResult;
        }

        @Override
        public int compareTo(EntryStatus other) {
            int result = this.checkResult.compareTo(other.checkResult);
            return result == 0 ? this.keyIndex - other.keyIndex : result;
        }

        public String toString() {
            String s = this.alias + " (verified: " + (Object)((Object)this.checkResult) + ")";
            if (this.builderIndex == 0) {
                return s;
            }
            return "Builder #" + this.builderIndex + ", alias: " + s;
        }
    }

    private static class KeyType {
        final String keyAlgorithm;
        final String sigKeyAlgorithm;

        KeyType(String algorithm) {
            int k = algorithm.indexOf(95);
            if (k == -1) {
                this.keyAlgorithm = algorithm;
                this.sigKeyAlgorithm = null;
            } else {
                this.keyAlgorithm = algorithm.substring(0, k);
                this.sigKeyAlgorithm = algorithm.substring(k + 1);
            }
        }

        boolean matches(Certificate[] chain) {
            if (!chain[0].getPublicKey().getAlgorithm().equals(this.keyAlgorithm)) {
                return false;
            }
            if (this.sigKeyAlgorithm == null) {
                return true;
            }
            if (chain.length > 1) {
                return this.sigKeyAlgorithm.equals(chain[1].getPublicKey().getAlgorithm());
            }
            X509Certificate issuer = (X509Certificate)chain[0];
            String sigAlgName = issuer.getSigAlgName().toUpperCase(Locale.ENGLISH);
            String pattern = "WITH" + this.sigKeyAlgorithm.toUpperCase(Locale.ENGLISH);
            return sigAlgName.contains(pattern);
        }
    }

    private static enum CheckResult {
        OK,
        INSENSITIVE,
        EXPIRED,
        EXTENSION_MISMATCH;

    }
}

