/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;
import sun.security.util.Debug;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final Debug debug = Debug.getInstance("ts");
    private URI tsaURI = null;

    public HttpTimestamper(URI tsaURI) {
        if (!tsaURI.getScheme().equalsIgnoreCase("http") && !tsaURI.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("TSA must be an HTTP or HTTPS URI");
        }
        this.tsaURI = tsaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSResponse generateTimestamp(TSRequest tsQuery) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.tsaURI.toURL().openConnection();
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(15000);
        if (debug != null) {
            Set<Map.Entry<String, List<String>>> headers = connection.getRequestProperties().entrySet();
            debug.println(connection.getRequestMethod() + " " + this.tsaURI + " HTTP/1.1");
            for (Map.Entry<String, List<String>> e : headers) {
                debug.println("  " + e);
            }
            debug.println();
        }
        connection.connect();
        try (DataOutputStream output = null;){
            output = new DataOutputStream(connection.getOutputStream());
            byte[] request = tsQuery.encode();
            output.write(request, 0, request.length);
            output.flush();
            if (debug != null) {
                debug.println("sent timestamp query (length=" + request.length + ")");
            }
        }
        byte[] replyBuffer = null;
        try (BufferedInputStream input = null;){
            input = new BufferedInputStream(connection.getInputStream());
            if (debug != null) {
                String header = connection.getHeaderField(0);
                debug.println(header);
                int i = 1;
                while ((header = connection.getHeaderField(i)) != null) {
                    String key = connection.getHeaderFieldKey(i);
                    debug.println("  " + (key == null ? "" : key + ": ") + header);
                    ++i;
                }
                debug.println();
            }
            HttpTimestamper.verifyMimeType(connection.getContentType());
            int clen = connection.getContentLength();
            replyBuffer = input.readAllBytes();
            if (clen != -1 && replyBuffer.length != clen) {
                throw new EOFException("Expected:" + clen + ", read:" + replyBuffer.length);
            }
            if (debug != null) {
                debug.println("received timestamp response (length=" + replyBuffer.length + ")");
            }
        }
        return new TSResponse(replyBuffer);
    }

    private static void verifyMimeType(String contentType) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(contentType)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

