/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import sun.security.util.FilePaths;
import sun.security.util.PropertyExpander;

public class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        return KeyStoreUtil.signedBy(cert, cert);
    }

    public static boolean signedBy(X509Certificate end, X509Certificate ca) {
        if (!ca.getSubjectX500Principal().equals(end.getIssuerX500Principal())) {
            return false;
        }
        try {
            end.verify(ca.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindowsKeyStore(String storetype) {
        return storetype != null && (storetype.equalsIgnoreCase("Windows-MY") || storetype.equalsIgnoreCase("Windows-ROOT"));
    }

    public static String niceStoreTypeName(String storetype) {
        if (storetype.equalsIgnoreCase("Windows-MY")) {
            return "Windows-MY";
        }
        if (storetype.equalsIgnoreCase("Windows-ROOT")) {
            return "Windows-ROOT";
        }
        return storetype.toUpperCase(Locale.ENGLISH);
    }

    public static String getCacerts() {
        return FilePaths.cacerts();
    }

    public static KeyStore getCacertsKeyStore() throws Exception {
        File file = new File(KeyStoreUtil.getCacerts());
        if (!file.exists()) {
            return null;
        }
        return KeyStore.getInstance(file, (char[])null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getPassWithModifier(String modifier, String arg, ResourceBundle rb, Collator collator) {
        if (modifier == null) {
            return arg.toCharArray();
        }
        if (collator.compare(modifier, "env") == 0) {
            String value = System.getenv(arg);
            if (value != null) return value.toCharArray();
            System.err.println(rb.getString("Cannot.find.environment.variable.") + arg);
            return null;
        }
        if (collator.compare(modifier, "file") != 0) {
            System.err.println(rb.getString("Unknown.password.type.") + modifier);
            return null;
        }
        try {
            URL url = null;
            try {
                url = new URL(arg);
            }
            catch (MalformedURLException mue) {
                File f = new File(arg);
                if (!f.exists()) {
                    System.err.println(rb.getString("Cannot.find.file.") + arg);
                    return null;
                }
                url = f.toURI().toURL();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
                String value = br.readLine();
                if (value == null) {
                    char[] cArray = new char[]{};
                    return cArray;
                }
                char[] cArray = value.toCharArray();
                return cArray;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return null;
        }
    }

    private static void parseArgsLine(List<String> list, String s) throws IOException, PropertyExpander.ExpandException {
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        while (st.nextToken() != -1) {
            list.add(PropertyExpander.expand(st.sval));
        }
    }

    public static String[] expandArgs(String tool, String file, String c1, String c2, String[] args) throws IOException, PropertyExpander.ExpandException {
        ArrayList<String> result = new ArrayList<String>();
        Properties p = new Properties();
        p.load(new FileInputStream(file));
        String s = p.getProperty(tool + ".all");
        if (s != null) {
            KeyStoreUtil.parseArgsLine(result, s);
        }
        String s1 = p.getProperty(tool + "." + c1.substring(1));
        String s2 = null;
        if (c2 != null) {
            s2 = p.getProperty(tool + "." + c2.substring(1));
        }
        if (s1 != null && s2 != null) {
            throw new IOException("Cannot have both " + c1 + " and " + c2 + " as pre-configured options");
        }
        if (s1 == null) {
            s1 = s2;
        }
        if (s1 != null) {
            KeyStoreUtil.parseArgsLine(result, s1);
        }
        if (result.isEmpty()) {
            return args;
        }
        result.addAll(Arrays.asList(args));
        return result.toArray(new String[result.size()]);
    }

    public static void loadProviderByName(String provName, String arg) {
        Provider loaded = Security.getProvider(provName);
        if (loaded != null) {
            if (arg != null) {
                loaded = loaded.configure(arg);
                Security.addProvider(loaded);
            }
            return;
        }
        for (Provider p : ServiceLoader.load(Provider.class, ClassLoader.getSystemClassLoader())) {
            if (!p.getName().equals(provName)) continue;
            if (arg != null) {
                p = p.configure(arg);
            }
            Security.addProvider(p);
            return;
        }
        throw new IllegalArgumentException("No provider found");
    }

    public static void loadProviderByClass(String provClass, String arg, ClassLoader cl) {
        Provider prov;
        if (provClass.equals("sun.security.pkcs11.SunPKCS11")) {
            KeyStoreUtil.loadProviderByName("SunPKCS11", arg);
            return;
        }
        if (provClass.equals("sun.security.mscapi.SunMSCAPI")) {
            KeyStoreUtil.loadProviderByName("SunMSCAPI", arg);
            return;
        }
        try {
            Class<?> clazz = Class.forName(provClass, false, cl);
            prov = (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
        if (arg != null) {
            prov = prov.configure(arg);
        }
        Security.addProvider(prov);
    }
}

