/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.keytool;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sun.security.util.SignatureUtil;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import sun.security.x509.X509Key;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String keyType;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private boolean signerFlag;
    private PrivateKey signerPrivateKey;
    private X500Name signerSubjectName;

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
        this.keyType = keyType;
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        this(keyType, sigAlg, providerName, null, null);
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName, PrivateKey signerPrivateKey, X500Name signerSubjectName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        } else {
            try {
                this.keyGen = KeyPairGenerator.getInstance(keyType, providerName);
            }
            catch (Exception e) {
                this.keyGen = KeyPairGenerator.getInstance(keyType);
            }
        }
        this.sigAlg = sigAlg;
        this.keyType = keyType;
        this.signerPrivateKey = signerPrivateKey;
        this.signerSubjectName = signerSubjectName;
        this.signerFlag = signerPrivateKey != null;
    }

    public void setRandom(SecureRandom generator) {
        this.prng = generator;
    }

    public void generate(String name) {
        block6: {
            try {
                if (this.prng == null) {
                    this.prng = new SecureRandom();
                }
                try {
                    this.keyGen.initialize(new NamedParameterSpec(name), this.prng);
                }
                catch (InvalidAlgorithmParameterException e) {
                    if (this.keyType.equalsIgnoreCase("EC")) {
                        this.keyGen.initialize(new ECGenParameterSpec(name), this.prng);
                        break block6;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.generateInternal();
    }

    public void generate(int keyBits) {
        if (keyBits != -1) {
            try {
                if (this.prng == null) {
                    this.prng = new SecureRandom();
                }
                this.keyGen.initialize(keyBits, this.prng);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.generateInternal();
    }

    private void generateInternal() {
        KeyPair pair = this.keyGen.generateKeyPair();
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (!"X.509".equalsIgnoreCase(this.publicKey.getFormat())) {
            throw new IllegalArgumentException("Public key format is " + this.publicKey.getFormat() + ", must be X.509");
        }
        if (this.sigAlg == null) {
            if (this.signerFlag) {
                this.sigAlg = SignatureUtil.getDefaultSigAlgForKey(this.signerPrivateKey);
                if (this.sigAlg == null) {
                    throw new IllegalArgumentException("Cannot derive signature algorithm from " + this.signerPrivateKey.getAlgorithm());
                }
            } else {
                this.sigAlg = SignatureUtil.getDefaultSigAlgForKey(this.privateKey);
                if (this.sigAlg == null) {
                    throw new IllegalArgumentException("Cannot derive signature algorithm from " + this.privateKey.getAlgorithm());
                }
            }
        }
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, firstDate, validity, null);
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            c.setTime(lastDate);
            if (c.get(1) > 9999) {
                throw new CertificateException("Validity period ends at calendar year " + c.get(1) + " which is greater than 9999");
            }
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            info.set("serialNumber", CertificateSerialNumber.newRandom64bit(this.prng));
            info.set("subject", myname);
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            if (this.signerFlag) {
                info.set("issuer", this.signerSubjectName);
            } else {
                info.set("issuer", myname);
            }
            if (ext != null) {
                info.set("extensions", ext);
            }
            X509CertImpl cert = new X509CertImpl(info);
            if (this.signerFlag) {
                cert.sign(this.signerPrivateKey, this.sigAlg);
            } else {
                cert.sign(this.privateKey, this.sigAlg);
            }
            return cert;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, new Date(), validity);
    }
}

