/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.FilePermission;
import java.security.Permission;
import jdk.internal.access.SharedSecrets;
import sun.security.util.SecurityProperties;

public class FilePermCompat {
    public static final boolean nb;
    public static final boolean compat;

    public static Permission newPermPlusAltPath(Permission input) {
        if (compat && input instanceof FilePermission) {
            return SharedSecrets.getJavaIOFilePermissionAccess().newPermPlusAltPath((FilePermission)input);
        }
        return input;
    }

    public static Permission newPermUsingAltPath(Permission input) {
        if (input instanceof FilePermission) {
            return SharedSecrets.getJavaIOFilePermissionAccess().newPermUsingAltPath((FilePermission)input);
        }
        return null;
    }

    static {
        String flag = SecurityProperties.privilegedGetOverridable("jdk.io.permissionsUseCanonicalPath");
        if (flag == null) {
            flag = "false";
        }
        switch (flag) {
            case "true": {
                nb = false;
                compat = false;
                break;
            }
            case "false": {
                nb = true;
                compat = true;
                break;
            }
            default: {
                throw new RuntimeException("Invalid jdk.io.permissionsUseCanonicalPath: " + flag);
            }
        }
    }
}

