/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class HexDumpEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];
    protected PrintStream pStream;

    static void hexDigit(PrintStream p, byte x) {
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
    }

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 16;
    }

    protected void encodeBufferPrefix(OutputStream o) throws IOException {
        this.offset = 0;
        this.pStream = new PrintStream(o);
    }

    protected void encodeLinePrefix(OutputStream o, int len) throws IOException {
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset & 0xFF));
        this.pStream.print(": ");
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    protected void encodeAtom(OutputStream o, byte[] buf, int off, int len) throws IOException {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(this.pStream, buf[off]);
        this.pStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.pStream.print("  ");
        }
    }

    protected void encodeLineSuffix(OutputStream o) throws IOException {
        int i;
        if (this.thisLineLength < 16) {
            for (i = this.thisLineLength; i < 16; ++i) {
                this.pStream.print("   ");
                if (i != 7) continue;
                this.pStream.print("  ");
            }
        }
        this.pStream.print(" ");
        for (i = 0; i < this.thisLineLength; ++i) {
            if (this.thisLine[i] < 32 || this.thisLine[i] > 122) {
                this.pStream.print(".");
                continue;
            }
            this.pStream.write(this.thisLine[i]);
        }
        this.pStream.println();
        this.offset += this.thisLineLength;
    }

    protected int readFully(InputStream in, byte[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            int q = in.read();
            if (q == -1) {
                return i;
            }
            buffer[i] = (byte)q;
        }
        return buffer.length;
    }

    public void encode(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = this.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += this.bytesPerAtom()) {
                if (j + this.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            if (numBytes < this.bytesPerLine()) break;
            this.encodeLineSuffix(outStream);
        }
    }

    public String encode(byte[] aBuffer) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        try {
            this.encode(inStream, outStream);
            return outStream.toString(StandardCharsets.ISO_8859_1);
        }
        catch (IOException ignore) {
            throw new Error("CharacterEncoder.encode internal error");
        }
    }

    private byte[] getBytes(ByteBuffer bb) {
        byte[] tmp;
        byte[] buf = null;
        if (bb.hasArray() && (tmp = bb.array()).length == bb.capacity() && tmp.length == bb.remaining()) {
            buf = tmp;
            bb.position(bb.limit());
        }
        if (buf == null) {
            buf = new byte[bb.remaining()];
            bb.get(buf);
        }
        return buf;
    }

    public String encode(ByteBuffer aBuffer) {
        byte[] buf = this.getBytes(aBuffer);
        return this.encode(buf);
    }

    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = this.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += this.bytesPerAtom()) {
                if (j + this.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            this.encodeLineSuffix(outStream);
            if (numBytes >= this.bytesPerLine()) continue;
            break;
        }
    }

    public void encodeBuffer(byte[] aBuffer, OutputStream aStream) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        this.encodeBuffer(inStream, aStream);
    }

    public String encodeBuffer(byte[] aBuffer) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        try {
            this.encodeBuffer(inStream, (OutputStream)outStream);
        }
        catch (Exception IOException2) {
            throw new Error("CharacterEncoder.encodeBuffer internal error");
        }
        return outStream.toString();
    }

    public void encodeBuffer(ByteBuffer aBuffer, OutputStream aStream) throws IOException {
        byte[] buf = this.getBytes(aBuffer);
        this.encodeBuffer(buf, aStream);
    }
}

