/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;

public final class LazyCodeSourcePermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -6727011328946861783L;
    private final PermissionCollection perms;
    private final CodeSource cs;
    private volatile boolean permissionAdded;

    public LazyCodeSourcePermissionCollection(PermissionCollection perms, CodeSource cs) {
        this.perms = perms;
        this.cs = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAdded() {
        if (!this.permissionAdded) {
            PermissionCollection permissionCollection = this.perms;
            synchronized (permissionCollection) {
                if (this.permissionAdded) {
                    return;
                }
                URL location = this.cs.getLocation();
                if (location != null) {
                    try {
                        Permission p = location.openConnection().getPermission();
                        if (p != null) {
                            String path;
                            if (p instanceof FilePermission && (path = p.getName()).endsWith(File.separator)) {
                                path = path + "-";
                                p = new FilePermission(path, "read");
                            }
                            this.perms.add(p);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.isReadOnly()) {
                    this.perms.setReadOnly();
                }
                this.permissionAdded = true;
            }
        }
    }

    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        this.perms.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        this.ensureAdded();
        return this.perms.implies(permission);
    }

    @Override
    public Enumeration<Permission> elements() {
        this.ensureAdded();
        return this.perms.elements();
    }

    @Override
    public String toString() {
        this.ensureAdded();
        return this.perms.toString();
    }

    private Object writeReplace() {
        this.ensureAdded();
        return this.perms;
    }
}

