/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.text.MessageFormat;
import sun.security.util.Resources;
import sun.security.util.ResourcesMgr;

public class LocalizedMessage {
    private static final Resources RESOURCES = new Resources();
    private final String key;

    public LocalizedMessage(String key) {
        this.key = key;
    }

    public String formatLocalized(Object ... arguments) {
        return LocalizedMessage.getLocalized(this.key, arguments);
    }

    public String formatNonlocalized(Object ... arguments) {
        return LocalizedMessage.getNonlocalized(this.key, arguments);
    }

    public static String getNonlocalized(String key, Object ... arguments) {
        int nextBraceIndex;
        String value = RESOURCES.getString(key);
        if (arguments == null || arguments.length == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        while ((nextBraceIndex = value.indexOf(123)) >= 0) {
            String firstPart = value.substring(0, nextBraceIndex);
            sb.append(firstPart);
            value = value.substring(nextBraceIndex + 1);
            nextBraceIndex = value.indexOf(125);
            if (nextBraceIndex < 0) {
                throw new RuntimeException("Unmatched braces");
            }
            String indexStr = value.substring(0, nextBraceIndex);
            try {
                int index = Integer.parseInt(indexStr);
                sb.append(arguments[index]);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("not an integer: " + indexStr);
            }
            value = value.substring(nextBraceIndex + 1);
        }
        sb.append(value);
        return sb.toString();
    }

    public static String getLocalized(String key, Object ... arguments) {
        String value = ResourcesMgr.getString(key);
        if (arguments == null) {
            return value;
        }
        MessageFormat form = new MessageFormat(value);
        return form.format(arguments);
    }
}

