/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomial25519
extends IntegerPolynomial {
    private static final int POWER = 255;
    private static final int SUBTRAHEND = 19;
    private static final int NUM_LIMBS = 10;
    private static final int BITS_PER_LIMB = 26;
    public static final BigInteger MODULUS = TWO.pow(255).subtract(BigInteger.valueOf(19L));
    private static final int BIT_OFFSET = 5;
    private static final int LIMB_MASK = 0x3FFFFFF;
    private static final int RIGHT_BIT_OFFSET = 21;

    public IntegerPolynomial25519() {
        super(26, 10, 1, MODULUS);
    }

    @Override
    protected void reduceIn(long[] limbs, long v, int i) {
        long t0 = 19L * v;
        int n = i - 10;
        limbs[n] = limbs[n] + (t0 << 5 & 0x3FFFFFFL);
        int n2 = i - 9;
        limbs[n2] = limbs[n2] + (t0 >> 21);
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        long reducedValue = limbs[this.numLimbs - 1] >> 21;
        int n = this.numLimbs - 1;
        limbs[n] = limbs[n] - (reducedValue << 21);
        limbs[0] = limbs[0] + reducedValue * 19L;
    }

    @Override
    protected void reduce(long[] a) {
        long carry8 = this.carryValue(a[8]);
        a[8] = a[8] - (carry8 << 26);
        a[9] = a[9] + carry8;
        long carry9 = this.carryValue(a[9]);
        a[9] = a[9] - (carry9 << 26);
        long reducedValue10 = carry9 * 19L;
        a[0] = a[0] + (reducedValue10 << 5 & 0x3FFFFFFL);
        a[1] = a[1] + (reducedValue10 >> 21);
        this.carry(a, 0, 9);
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long c0 = a[0] * b[0];
        long c1 = a[0] * b[1] + a[1] * b[0];
        long c2 = a[0] * b[2] + a[1] * b[1] + a[2] * b[0];
        long c3 = a[0] * b[3] + a[1] * b[2] + a[2] * b[1] + a[3] * b[0];
        long c4 = a[0] * b[4] + a[1] * b[3] + a[2] * b[2] + a[3] * b[1] + a[4] * b[0];
        long c5 = a[0] * b[5] + a[1] * b[4] + a[2] * b[3] + a[3] * b[2] + a[4] * b[1] + a[5] * b[0];
        long c6 = a[0] * b[6] + a[1] * b[5] + a[2] * b[4] + a[3] * b[3] + a[4] * b[2] + a[5] * b[1] + a[6] * b[0];
        long c7 = a[0] * b[7] + a[1] * b[6] + a[2] * b[5] + a[3] * b[4] + a[4] * b[3] + a[5] * b[2] + a[6] * b[1] + a[7] * b[0];
        long c8 = a[0] * b[8] + a[1] * b[7] + a[2] * b[6] + a[3] * b[5] + a[4] * b[4] + a[5] * b[3] + a[6] * b[2] + a[7] * b[1] + a[8] * b[0];
        long c9 = a[0] * b[9] + a[1] * b[8] + a[2] * b[7] + a[3] * b[6] + a[4] * b[5] + a[5] * b[4] + a[6] * b[3] + a[7] * b[2] + a[8] * b[1] + a[9] * b[0];
        long c10 = a[1] * b[9] + a[2] * b[8] + a[3] * b[7] + a[4] * b[6] + a[5] * b[5] + a[6] * b[4] + a[7] * b[3] + a[8] * b[2] + a[9] * b[1];
        long c11 = a[2] * b[9] + a[3] * b[8] + a[4] * b[7] + a[5] * b[6] + a[6] * b[5] + a[7] * b[4] + a[8] * b[3] + a[9] * b[2];
        long c12 = a[3] * b[9] + a[4] * b[8] + a[5] * b[7] + a[6] * b[6] + a[7] * b[5] + a[8] * b[4] + a[9] * b[3];
        long c13 = a[4] * b[9] + a[5] * b[8] + a[6] * b[7] + a[7] * b[6] + a[8] * b[5] + a[9] * b[4];
        long c14 = a[5] * b[9] + a[6] * b[8] + a[7] * b[7] + a[8] * b[6] + a[9] * b[5];
        long c15 = a[6] * b[9] + a[7] * b[8] + a[8] * b[7] + a[9] * b[6];
        long c16 = a[7] * b[9] + a[8] * b[8] + a[9] * b[7];
        long c17 = a[8] * b[9] + a[9] * b[8];
        long c18 = a[9] * b[9];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18);
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18) {
        long reducedValue17 = c17 * 19L;
        c7 += reducedValue17 << 5 & 0x3FFFFFFL;
        c8 += reducedValue17 >> 21;
        long reducedValue18 = c18 * 19L;
        c9 += reducedValue18 >> 21;
        long carry8 = this.carryValue(c8 += reducedValue18 << 5 & 0x3FFFFFFL);
        r[8] = c8 - (carry8 << 26);
        long carry9 = this.carryValue(c9 += carry8);
        r[9] = c9 - (carry9 << 26);
        long reducedValue10 = (c10 += carry9) * 19L;
        r[0] = c0 + (reducedValue10 << 5 & 0x3FFFFFFL);
        long reducedValue11 = c11 * 19L;
        r[1] = (c1 += reducedValue10 >> 21) + (reducedValue11 << 5 & 0x3FFFFFFL);
        long reducedValue12 = c12 * 19L;
        r[2] = (c2 += reducedValue11 >> 21) + (reducedValue12 << 5 & 0x3FFFFFFL);
        long reducedValue13 = c13 * 19L;
        r[3] = (c3 += reducedValue12 >> 21) + (reducedValue13 << 5 & 0x3FFFFFFL);
        long reducedValue14 = c14 * 19L;
        r[4] = (c4 += reducedValue13 >> 21) + (reducedValue14 << 5 & 0x3FFFFFFL);
        long reducedValue15 = c15 * 19L;
        r[5] = (c5 += reducedValue14 >> 21) + (reducedValue15 << 5 & 0x3FFFFFFL);
        long reducedValue16 = c16 * 19L;
        r[6] = (c6 += reducedValue15 >> 21) + (reducedValue16 << 5 & 0x3FFFFFFL);
        r[7] = c7 + (reducedValue16 >> 21);
        this.carry(r, 0, 9);
    }

    @Override
    protected void square(long[] a, long[] r) {
        long c0 = a[0] * a[0];
        long c1 = 2L * a[0] * a[1];
        long c2 = a[1] * a[1] + 2L * a[0] * a[2];
        long c3 = 2L * (a[0] * a[3] + a[1] * a[2]);
        long c4 = a[2] * a[2] + 2L * (a[0] * a[4] + a[1] * a[3]);
        long c5 = 2L * (a[0] * a[5] + a[1] * a[4] + a[2] * a[3]);
        long c6 = a[3] * a[3] + 2L * (a[0] * a[6] + a[1] * a[5] + a[2] * a[4]);
        long c7 = 2L * (a[0] * a[7] + a[1] * a[6] + a[2] * a[5] + a[3] * a[4]);
        long c8 = a[4] * a[4] + 2L * (a[0] * a[8] + a[1] * a[7] + a[2] * a[6] + a[3] * a[5]);
        long c9 = 2L * (a[0] * a[9] + a[1] * a[8] + a[2] * a[7] + a[3] * a[6] + a[4] * a[5]);
        long c10 = a[5] * a[5] + 2L * (a[1] * a[9] + a[2] * a[8] + a[3] * a[7] + a[4] * a[6]);
        long c11 = 2L * (a[2] * a[9] + a[3] * a[8] + a[4] * a[7] + a[5] * a[6]);
        long c12 = a[6] * a[6] + 2L * (a[3] * a[9] + a[4] * a[8] + a[5] * a[7]);
        long c13 = 2L * (a[4] * a[9] + a[5] * a[8] + a[6] * a[7]);
        long c14 = a[7] * a[7] + 2L * (a[5] * a[9] + a[6] * a[8]);
        long c15 = 2L * (a[6] * a[9] + a[7] * a[8]);
        long c16 = a[8] * a[8] + 2L * a[7] * a[9];
        long c17 = 2L * a[8] * a[9];
        long c18 = a[9] * a[9];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18);
    }
}

