/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private static final long serialVersionUID = 3437177836797504046L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        return this.q;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    @Deprecated
    public AlgIdDSA() {
    }

    public AlgIdDSA(BigInteger p, BigInteger q, BigInteger g) {
        super(DSA_oid);
        if (p != null || q != null || g != null) {
            if (p == null || q == null || g == null) {
                throw new ProviderException("Invalid parameters for DSS/DSA Algorithm ID");
            }
            try {
                this.p = p;
                this.q = q;
                this.g = g;
                this.initializeParams();
            }
            catch (IOException e) {
                throw new ProviderException("Construct DSS/DSA Algorithm ID");
            }
        }
    }

    @Override
    public String getName() {
        return "DSA";
    }

    private void initializeParams() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putInteger(this.p);
        out.putInteger(this.q);
        out.putInteger(this.g);
        DerOutputStream result = new DerOutputStream();
        result.write((byte)48, out);
        this.encodedParams = result.toByteArray();
    }

    @Override
    protected void decodeParams() throws IOException {
        if (this.encodedParams == null) {
            throw new IOException("DSA alg params are null");
        }
        DerValue params = new DerValue(this.encodedParams);
        if (params.tag != 48) {
            throw new IOException("DSA alg parsing error");
        }
        params.data.reset();
        this.p = params.data.getBigInteger();
        this.q = params.data.getBigInteger();
        this.g = params.data.getBigInteger();
        if (params.data.available() != 0) {
            throw new IOException("AlgIdDSA params, extra=" + params.data.available());
        }
    }

    @Override
    public String toString() {
        return this.paramsToString();
    }

    @Override
    protected String paramsToString() {
        if (this.encodedParams == null) {
            return " null\n";
        }
        return "\n    p:\n" + Debug.toHexString(this.p) + "\n    q:\n" + Debug.toHexString(this.q) + "\n    g:\n" + Debug.toHexString(this.g) + "\n";
    }
}

