/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertificatePolicyId;

public class PolicyInformation {
    public static final String NAME = "PolicyInformation";
    public static final String ID = "id";
    public static final String QUALIFIERS = "qualifiers";
    private CertificatePolicyId policyIdentifier;
    private Set<PolicyQualifierInfo> policyQualifiers;

    public PolicyInformation(CertificatePolicyId policyIdentifier, Set<PolicyQualifierInfo> policyQualifiers) throws IOException {
        if (policyQualifiers == null) {
            throw new NullPointerException("policyQualifiers is null");
        }
        this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>(policyQualifiers);
        this.policyIdentifier = policyIdentifier;
    }

    public PolicyInformation(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of PolicyInformation");
        }
        this.policyIdentifier = new CertificatePolicyId(val.data.getDerValue());
        if (val.data.available() != 0) {
            this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>();
            DerValue opt = val.data.getDerValue();
            if (opt.tag != 48) {
                throw new IOException("Invalid encoding of PolicyInformation");
            }
            if (opt.data.available() == 0) {
                throw new IOException("No data available in policyQualifiers");
            }
            while (opt.data.available() != 0) {
                this.policyQualifiers.add(new PolicyQualifierInfo(opt.data.getDerValue().toByteArray()));
            }
        } else {
            this.policyQualifiers = Collections.emptySet();
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation piOther = (PolicyInformation)other;
        if (!this.policyIdentifier.equals(piOther.getPolicyIdentifier())) {
            return false;
        }
        return this.policyQualifiers.equals(piOther.getPolicyQualifiers());
    }

    public int hashCode() {
        int myhash = 37 + this.policyIdentifier.hashCode();
        myhash = 37 * myhash + this.policyQualifiers.hashCode();
        return myhash;
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(ID)) {
            return this.policyIdentifier;
        }
        if (name.equalsIgnoreCase(QUALIFIERS)) {
            return this.policyQualifiers;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by PolicyInformation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(ID)) {
            if (!(obj instanceof CertificatePolicyId)) throw new IOException("Attribute value must be instance of CertificatePolicyId.");
            this.policyIdentifier = (CertificatePolicyId)obj;
            return;
        } else {
            if (!name.equalsIgnoreCase(QUALIFIERS)) throw new IOException("Attribute name [" + name + "] not recognized by PolicyInformation");
            if (this.policyIdentifier == null) {
                throw new IOException("Attribute must have a CertificatePolicyIdentifier value before PolicyQualifierInfo can be set.");
            }
            if (!(obj instanceof Set)) throw new IOException("Attribute value must be of type Set.");
            for (Object obj1 : (Set)obj) {
                if (obj1 instanceof PolicyQualifierInfo) continue;
                throw new IOException("Attribute value must be aSet of PolicyQualifierInfo objects.");
            }
            this.policyQualifiers = (Set)obj;
        }
    }

    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(QUALIFIERS)) {
            if (name.equalsIgnoreCase(ID)) {
                throw new IOException("Attribute ID may not be deleted from PolicyInformation.");
            }
            throw new IOException("Attribute name [" + name + "] not recognized by PolicyInformation.");
        }
        this.policyQualifiers = Collections.emptySet();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ID);
        elements.addElement(QUALIFIERS);
        return elements.elements();
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return "  [" + this.policyIdentifier + this.policyQualifiers + "  ]\n";
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.policyIdentifier.encode(tmp);
        if (!this.policyQualifiers.isEmpty()) {
            DerOutputStream tmp2 = new DerOutputStream();
            for (PolicyQualifierInfo pq : this.policyQualifiers) {
                tmp2.write(pq.getEncoded());
            }
            tmp.write((byte)48, tmp2);
        }
        out.write((byte)48, tmp);
    }
}

